/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.manager;

import com.sapportals.wcm.repository.*;
import java.util.List;

/**
 * A lock manager implements locking operations for a specific repository.
 *
 * @author SAP AG
 * @version $Revision:$
 */
public interface ILockManager {
  /**
   * Lock the resource
   *
   * @param lockProperties The lock properties
   * @param resource The resource
   * @return The lock info, which contains the lock token
   * @exception ResourceException
   * @exception NotSupportedException
   * @exception AccessDeniedException If the resource is locked, readonly or
   *      authorization failed
   */
  public ILockInfo lock(ILockProperties lockProperties, IResource resource)
    throws ResourceException, NotSupportedException, AccessDeniedException;

  /**
   * Unlock the resource
   *
   * @param resource The resource
   * @param lockInfo TBD: Description of the incoming method parameter
   * @exception ResourceException
   * @exception NotSupportedException
   * @exception AccessDeniedException If the resource is locked, readonly or
   *      authorization failed
   */
  public void unlock(ILockInfo lockInfo, IResource resource)
    throws ResourceException, NotSupportedException, AccessDeniedException;

  /**
   * Refresh the lock.
   *
   * @param lockInfo The LockInfo representing the lock to refresh
   * @param resource The resource
   * @exception ResourceException
   * @exception NotSupportedException
   * @exception AccessDeniedException If the resource is locked, readonly or
   *      authorization failed
   */
  public void refreshLock(ILockInfo lockInfo, IResource resource)
    throws ResourceException, NotSupportedException, AccessDeniedException;

  /**
   * Get the locks that exist on this resource. May be null if the resource is
   * not locked.
   *
   * @param resource The resource
   * @return a List of LockInfo objects
   * @exception ResourceException
   * @exception NotSupportedException
   * @exception AccessDeniedException If the resource is locked, readonly or
   *      authorization failed
   */
  public List getLocks(IResource resource)
    throws ResourceException, NotSupportedException, AccessDeniedException;

}

