/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.manager;

import com.sapportals.wcm.repository.*;

/**
 * This insterface contains property related methods for performance
 * improvements.
 *
 * @author SAP AG
 * @version $Revision:$
 */
public interface IExtendedPropertyManager {

  /**
   * ** Returns a map with properties for the specified property names.
   *
   * @param resource The resource
   * @param propNameList TBD: Description of the incoming method parameter
   * @return A property map.
   * @exception ResourceException
   * @exception AccessDeniedException If the resource is locked, readonly or
   *      authorization failed
   */
  public IPropertyMap getProperties(IPropertyNameList propNameList, IResource resource)
    throws ResourceException, AccessDeniedException;

}

