package com.sapportals.wcm.repository.manager;

import com.sapportals.wcm.repository.IResourceContext;
import com.sapportals.wcm.repository.ResourceException;
import com.sapportals.wcm.util.uri.RID;

/**
 * Extension interface that allows to detect whether a resource exists without actually an {@link com.sapportals.wcm.repository.IResource} object being constructed.
 * <p>
 * Copyright (c) SAP AG 2004
 * @author martin.boettcher@greenbytes.de
 */
public interface IExistenceChecker {
	
	/**
	 * Checks whether a RID refers to an existing resource
	 * @param check RID of the resource which is to be tested
	 * @param context the resource context
	 * @return <code>true</code> if the RID refers to an existing resource, <code>false</code> otherwise
   * @throws ResourceException if it's impossible to decide (for instance because of IO problems).
	 */
	public boolean checkExistence(RID check, IResourceContext context) throws ResourceException;
}
