/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.manager;

import com.sapportals.wcm.repository.*;
import com.sapportals.wcm.util.content.IContent;

import java.io.InputStream;

/**
 * A content manager implements the content access operations for a specific
 * repository.
 *
 * @author SAP AG
 * @version $Revision:$
 */
public interface IContentManager {

  /**
   * Returns the content of a resource. Will return <code>null</code> if the
   * resource is a collection.
   *
   * @param resource The resource
   * @return An IContent reference
   * @exception ResourceException
   * @exception AccessDeniedException If the resource is locked, readonly or
   *      authorization failed
   */
  public IContent getContent(IResource resource)
    throws ResourceException, AccessDeniedException;

  /**
   * Update a resource with new content.
   *
   * @param content The new content
   * @param resource A resource object
   * @exception ResourceException
   * @exception NotSupportedException
   * @exception AccessDeniedException If the resource is locked, readonly or
   *      authorization failed
   */
  public void setContent(IContent content, IResource resource)
    throws ResourceException, NotSupportedException, AccessDeniedException;

  /**
   * Update a resource with new content and properties in an atomic operation.
   * This sould be implemented only if the repository has the ability to update
   * content and properties in one atomic operation. If properties fail the
   * content must not be changed.
   *
   * @param content The new content
   * @param properties A map of properties to set
   * @param resource A resource object
   * @exception ResourceException
   * @exception NotSupportedException
   * @exception AccessDeniedException If the resource is locked, readonly or
   *      authorization failed
   */
  public void setContentAndProperties(IContent content, IPropertyMap properties, IResource resource)
    throws ResourceException, NotSupportedException, AccessDeniedException;
}
