/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.eventmapper;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.repository.manager.AbstractResourceEventMapper;
import com.sapportals.wcm.repository.manager.IResourceEvent;
import com.sapportals.wcm.repository.manager.ResourceEvent;

import java.util.Properties;

/**
 * Implementation of an <code>IEventMapper</code> for some events, formerly
 * known as semantic events. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author paul.goetz@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/repository/framework/core/com/sapportals/wcm/repository/eventmapper/SemanticEvents.java#5
 *      $
 */
public class SemanticEvents
   extends AbstractResourceEventMapper {

  // ---------
  // Constants ----------------------------------------------------------------
  // ---------

  /**
   * A resource, link or folder was created.
   */
  public final static int NEW = 1;

  /**
   * A resource's content or a resource's properties where changed.
   */
  public final static int CHANGED = 2;

  /**
   * A resource, link or folder was deleted.
   */
  public final static int DELETED = 3;


  // -------------------
  // AbstractEventMapper ------------------------------------------------------
  // -------------------

  public SemanticEvents(String id,
    Properties properties)
    throws WcmException {

    super(id, properties);

  }


  public IResourceEvent map(IResourceEvent event) {

    if (!(event instanceof ResourceEvent)) {
      return null;
    }

    ResourceEvent resultEvent;

    ResourceEvent resourceEvent = (ResourceEvent)event;

    switch (resourceEvent.getType()) {

      case ResourceEvent.CREATE_CHILD:
      case ResourceEvent.CREATE_COLLECTION:
      case ResourceEvent.CREATE_LINK:
      {
        resultEvent = new ResourceEvent(
          (IResource)resourceEvent.getParameter(),
          NEW,
          resourceEvent.getCorrelationId(),
          resourceEvent
          );
      }
        break;
      case ResourceEvent.SET:
      case ResourceEvent.PROPERTY_SET:
      {
        resultEvent = new ResourceEvent(
          resourceEvent.getResource(),
          CHANGED,
          resourceEvent.getCorrelationId(),
          resourceEvent
          );
      }
        break;
      case ResourceEvent.DELETE:
      {
        resultEvent = new ResourceEvent(
          resourceEvent.getResource(),
          DELETED,
          resourceEvent.getCorrelationId(),
          resourceEvent
          );
      }
        break;
      default:
      {
        resultEvent = null;
      }

    }

    return resultEvent;
  }

}
