/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.eventmapper;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.manager.AbstractResourceEventMapper;
import com.sapportals.wcm.repository.manager.IResourceEvent;

import java.util.Properties;

/**
 * Implementation of an <code>IEventMapper</code> wich eliminates all events.
 * <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author paul.goetz@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/repository/framework/core/com/sapportals/wcm/repository/eventmapper/NullEvents.java#5
 *      $
 */
public class NullEvents
   extends AbstractResourceEventMapper {

  // -------------------
  // AbstractEventMapper ------------------------------------------------------
  // -------------------

  public NullEvents(String id,
    Properties properties)
    throws WcmException {

    super(id, properties);

  }


  public IResourceEvent map(IResourceEvent event) {

    return null;
  }

}
