/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository.eventmapper;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.IResource;
import com.sapportals.wcm.repository.manager.AbstractResourceEventMapper;
import com.sapportals.wcm.repository.manager.IResourceEvent;
import com.sapportals.wcm.repository.manager.ResourceEvent;

import java.util.Properties;

/**
 * Implementation of an <code>IEventMapper</code> wich passes all repository
 * events. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author paul.goetz@sapportals.com
 * @version $Id: //javabas/com.sapportals.wcm/50_COR/src/java/repository/framework/core/com/sapportals/wcm/repository/eventmapper/AllResourceEvents.java#5
 *      $
 */
public class AllResourceEvents
   extends AbstractResourceEventMapper {

  // -------------------
  // AbstractEventMapper ------------------------------------------------------
  // -------------------

  public AllResourceEvents(String id,
    Properties properties)
    throws WcmException {

    super(id, properties);

  }


  public IResourceEvent map(IResourceEvent event) {

    if (!(event instanceof ResourceEvent)) {
      return null;
    }

    ResourceEvent resultEvent;

    ResourceEvent resourceEvent = (ResourceEvent)event;

    switch (resourceEvent.getType()) {

      case ResourceEvent.CREATE_CHILD:
      case ResourceEvent.CREATE_COLLECTION:
      case ResourceEvent.CREATE_LINK:
      {
        resultEvent = new ResourceEvent(
          (IResource)resourceEvent.getParameter(),
          resourceEvent.getType(),
          resourceEvent.getCorrelationId(),
          resourceEvent
          );
      }
        break;
      default:
      {
        resultEvent = new ResourceEvent(
          resourceEvent.getResource(),
          resourceEvent.getType(),
          resourceEvent.getCorrelationId(),
          resourceEvent
          );
      }

    }

    return resultEvent;
  }

}
