/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import com.sapportals.wcm.repository.manager.IExtendedVersioningManager;
import com.sapportals.wcm.util.uri.IRidSet;

import com.sapportals.wcm.util.uri.RID;

/**
 * Workspace resource object impl. <p>
 *
 * Copyright 2002 (c) SAP AG
 *
 * @author manfred.baedke@greenbytes.de
 */
public class WorkspaceResourceImpl implements IWorkspaceResource {

  private final ICollection collection;
  private final IExtendedVersioningManager vmgr;

  public WorkspaceResourceImpl(ICollection collection, IExtendedVersioningManager vmgr) {
    this.collection = collection;
    this.vmgr = vmgr;
  }

  public IRidSet getCheckOutSet()
    throws ResourceException {
    return this.vmgr.getCheckOutSet(this.collection);
  }
}
