/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.repository.*;
import com.sapportals.wcm.repository.enum.*;
import com.sapportals.wcm.repository.manager.*;

import com.sapportals.wcm.util.content.IContent;

import com.sapportals.wcm.util.log.*;
import com.sapportals.wcm.util.name.*;
import com.sapportals.wcm.util.uri.*;

import java.util.*;

/**
 * Version controlled resource object impl. <p>
 *
 * Copyright 2002 (c) SAP AG
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: WorkingResourceImpl.java,v 1.1 2002/09/27 09:02:05 sei Exp $
 */

public final class WorkingResourceImpl implements IWorkingResource {

  private final IResource resource;
  private final IExtendedVersioningManager vmgr;

  public WorkingResourceImpl(IResource resource, IExtendedVersioningManager vmgr)
    throws ResourceException {
    this.resource = resource;
    this.vmgr = vmgr;
  }

  public RID getAutoUpdateVCR()
    throws ResourceException {
    return this.vmgr.getAutoUpdateVCR(this.resource);
  }
}
