/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.sap.tc.logging.Location;
import com.sapportals.wcm.crt.component.IComponent;
import com.sapportals.wcm.repository.enum.LinkType;
import com.sapportals.wcm.repository.enum.OrderType;
import com.sapportals.wcm.repository.manager.IContentManager;
import com.sapportals.wcm.repository.manager.IManagerFactory;
import com.sapportals.wcm.repository.manager.INamespaceManager;
import com.sapportals.wcm.repository.manager.IPermission;
import com.sapportals.wcm.repository.manager.IPropertyManager;
import com.sapportals.wcm.repository.manager.IRepositoryManager;
import com.sapportals.wcm.repository.manager.ISecurityManager;
import com.sapportals.wcm.util.content.IContent;
import com.sapportals.wcm.util.logging.LoggingFormatter;
import com.sapportals.wcm.util.uri.IRidList;
import com.sapportals.wcm.util.uri.RID;

/**
 * TBD: Description of the class.
 */
public class VirtualRootNamespaceContentPropertyManager
	implements INamespaceManager, IContentManager, IPropertyManager, IComponent {

	private static Location log =
		Location.getLocation(com.sapportals.wcm.repository.VirtualRootNamespaceContentPropertyManager.class);

	private final static String VIRTUAL_ROOT_DISPLAY_NAME = "root";

	private IRepositoryManager repositoryManager = null;

	public VirtualRootNamespaceContentPropertyManager(IRepositoryManager manager) throws ResourceException {
		this.repositoryManager = manager;
	}

	//////////////////////////////////////////////////////////////////////////////

	public void rename(String newName, IResource resource)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public void setContentAndProperties(IContent content, IPropertyMap properties, IResource resource)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public void setContent(IContent content, IResource resource)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public IRidList delete(ICollection collection)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public void delete(IResource resource) throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	/**
	 * Returns the rool collections of all available repositories
	 *
	 * @param collection TBD: Description of the incoming method parameter
	 * @return children
	 * @exception ResourceException Exception raised in failure situation
	 * @exception AccessDeniedException Exception raised in failure situation
	 */
	public IResourceList getChildren(ICollection collection) throws ResourceException, AccessDeniedException {

		Set excludeList = ((VirtualRootRepositoryManager) this.repositoryManager).getExcludeList();

		IResourceFactory rf = ResourceFactory.getInstance();
		IManagerFactory mf = rf.getManagerFactory();
		Collection managers = mf.getAllRepositoryManagers();

		ResourceList list = new ResourceList();

		if (managers == null) {
			return list;
		}

		Iterator it = managers.iterator();
		while (it.hasNext()) {
			IRepositoryManager mgr = (IRepositoryManager) it.next();

			if (mgr.getID().equals(this.repositoryManager.getID())) {
				continue;
			}
			synchronized (excludeList) {
				if (excludeList.contains(mgr.getID())) {
					continue;
				}
			}

			String prefix = mgr.getPrefix();
			IResource root = null;

			try {
				long before = System.currentTimeMillis();
				root = rf.getResource(RID.getRID(prefix), collection.getContext());
				if (VirtualRootNamespaceContentPropertyManager.log.beDebug()) {
					VirtualRootNamespaceContentPropertyManager.log.debugT(
						"Lookup of root collection for : prefix=" + prefix + ", time=" + (System.currentTimeMillis() - before));
				}
			}
			catch (ResourceException ex) {
				VirtualRootNamespaceContentPropertyManager.log.errorT(
					"caught ResourceException getting root collection of repository: " + mgr.getID(),
					LoggingFormatter.extractCallstack(ex));
			}
			catch (RuntimeException ex) {
				VirtualRootNamespaceContentPropertyManager.log.errorT(
					"caught RuntimeException getting root collection of repository: " + mgr.getID(),
					LoggingFormatter.extractCallstack(ex));
			}

			if (root == null) {
				VirtualRootNamespaceContentPropertyManager.log.errorT(
					"the repository returned no root collection (null): " + mgr.getID());
				continue;
			}

			// Hide the repository if the user has no LIST permission for the root collection
			boolean visible = true;
			ISecurityManager sm = null;
			try {
				sm = root.getRepositoryManager().getSecurityManager(root);
			}
			catch (ResourceException ex) {
				VirtualRootNamespaceContentPropertyManager.log.errorT(
					"caught ResourceException getting security manager of repository: " + mgr.getID(),
					LoggingFormatter.extractCallstack(ex));
			}
			if (sm != null) {
				try {
					visible =
						sm.isAllowed(root, collection.getContext().getUser(), sm.getPermission(IPermission.PERMISSION_LIST));
				}
				catch (ResourceException ex) {
					VirtualRootNamespaceContentPropertyManager.log.errorT(
						"caught ResourceException checking permission of root collection of repository:" + mgr.getID(),
						LoggingFormatter.extractCallstack(ex));
				}
				catch (RuntimeException ex) {
					VirtualRootNamespaceContentPropertyManager.log.errorT(
						"caught RuntimeException checking permission of root collection of repository:" + mgr.getID(),
						LoggingFormatter.extractCallstack(ex));
				}
			}

			if (visible) {
				list.add(root);
			}
			else {
				if (VirtualRootNamespaceContentPropertyManager.log.beDebug()) {
					VirtualRootNamespaceContentPropertyManager.log.debugT(
						"hiding root collection of repository <"
							+ mgr.getID()
							+ "> because user <"
							+ collection.getContext().getUser()
							+ "> does not have IPermission.PERMISSION_LIST");
				}
			}

		} // while

		return list;
	}

	public IContent getContent(IResource resource) throws ResourceException, AccessDeniedException {
		return null;
	}

	public ICollection createCollection(
		String name,
		IPosition position,
		IPropertyMap properties,
		boolean omitProperties,
		ICollection collection)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public IResource createResource(
		String name,
		IPosition position,
		IPropertyMap properties,
		IContent content,
		boolean omitProperties,
		ICollection collection)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public ILockInfo createResource(String name, ILockProperties lockProps, ICollection collection)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public OrderType getOrderType(ICollection collection) throws ResourceException {
		return OrderType.NONE;
	}

	public void setOrderType(OrderType orderType, ICollection collection)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public void reorder(IReorderList list, ICollection collection)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public IResource createLink(
		String name,
		String targetURL,
		LinkType linkType,
		IPosition position,
		IPropertyMap properties,
		boolean omitProperties,
		ICollection collection)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public void changePosition(IPosition position, IResource resource)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public void updateLink(String targetURL, LinkType linkType, IResource resource)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public IResource copy(RID destinationRID, ICopyParameter param, IResource resource)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public IResource copy(RID destinationRID, IPosition position, ICopyParameter param, IResource resource)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public IResource move(RID destinationRID, ICopyParameter param, IResource resource)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public IResource move(RID destinationRID, IPosition position, ICopyParameter param, IResource resource)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public IPropertyMap getProperties(IResource resource) throws ResourceException, AccessDeniedException {
		IMutablePropertyMap propMap = new MutablePropertyMap();
		propMap.put(Property.createDisplaynameProp(VIRTUAL_ROOT_DISPLAY_NAME));
		return propMap.getImmutable();
	}

	public void setProperty(IProperty prop, IResource resource)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

	public void setProperties(IPropertyMap props, IResource resource)
		throws ResourceException, NotSupportedException, AccessDeniedException, SetPropertiesException {
		throw new NotSupportedException();
	}

	public void setProperties(List propChangeList, IResource resource)
		throws ResourceException, NotSupportedException, AccessDeniedException, SetPropertiesException {
		throw new NotSupportedException();
	}

	public IProperty getProperty(IPropertyName propName, IResource resource)
		throws ResourceException, AccessDeniedException {
		return getProperties(resource).get(propName);
		// return null;
	}

	public void deleteProperty(IPropertyName propName, IResource resource)
		throws ResourceException, NotSupportedException, AccessDeniedException {
		throw new NotSupportedException();
	}

}
