/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.repository.manager.IExtendedVersioningManager;
import com.sapportals.wcm.util.uri.IRidSet;
import com.sapportals.wcm.util.uri.RID;

/**
 * version history resource object impl. <p>
 *
 * Copyright (c) SAP AG 2002-2003
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: VersionHistoryResourceImpl.java,v 1.3 2003/02/17 14:24:04 jre
 *      Exp $
 */

public final class VersionHistoryResourceImpl implements IVersionHistoryResource {

  private final IResource resource;
  private final IExtendedVersioningManager vmgr;

  public VersionHistoryResourceImpl(IResource resource, IExtendedVersioningManager vmgr)
    throws ResourceException {
    this.resource = resource;
    this.vmgr = vmgr;
  }


  public IResource getRootVersionResource()
    throws ResourceException {
    return this.vmgr.getRootVersionResource(this.resource);
  }

  public RID getRootVersionRID()
    throws ResourceException {
    return this.vmgr.getRootVersionRID(this.resource);
  }

  public RID getVersionRIDByLabel(String label)
    throws ResourceException {
    return this.vmgr.getVersionRIDByLabel(label, this.resource);
  }

  public IResource getVersionResourceByLabel(String label)
    throws ResourceException {
    return this.vmgr.getVersionResourceByLabel(label, this.resource);
  }

  public IRidSet getVersionControlledResourceRIDs()
    throws ResourceException {
    return this.vmgr.getVersionControlledResourceRIDs(null, this.resource);
  }

  public IRidSet getVersionControlledResourceRIDs(RID scope)
    throws ResourceException {
    return this.vmgr.getVersionControlledResourceRIDs(scope, this.resource);
  }

  public IResourceList getVersionResourceSet()
    throws ResourceException {
    return this.vmgr.getVersionResourceSet(this.resource);
  }

  public IRidSet getVersionRidSet()
    throws ResourceException {
    return this.vmgr.getVersionRIDs(this.resource);
  }
}
