/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import java.util.Comparator;
import java.util.Iterator;

/**
 * A list of revisions of a resource. When a resource becomes a versioned
 * resource 1. the resource becomes read-only - it must be checked out before
 * content or properties can be modified 2. a version history is created for
 * that resource. The history will initially contain a revision resource with
 * the initial revision ID of the versioned resource. <p>
 *
 * With each checkIn/checkOut a new revision resource is created in the history.
 * The first resource in the history will alway be the oldest revision. The
 * revisions are ordered ascending by the revisionID/last modified date. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Revision: 1.23 $
 */
public class VersionHistory extends ResourceList implements IVersionHistory {

  public VersionHistory() {
    super();
  }


  /**
   * Get a versioned resource by revision identifier. Returns null if no
   * resource is found.
   *
   * @param revisionID The revision identifier
   * @return The resource object for the revision
   */
  public IResource getRevision(String revisionID) {
    IResourceListIterator it = listIterator();
    while (it.hasNext()) {
      IResource res = it.next();
      if (res.getRevisionID().equals(revisionID)) {
        return res;
      }
    }
    return null;
  }
}
