/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.repository.manager.IExtendedVersioningManager;

/**
 * version controller object impl. <p>
 *
 * Copyright (c) SAP AG 2002-2003
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: VersionControllerImpl.java,v 1.2 2003/02/17 14:24:04 jre Exp $
 */

public final class VersionControllerImpl implements IVersionController {

  private final IResource resource;
  private final IExtendedVersioningManager vmgr;

  public VersionControllerImpl(IResource resource, IExtendedVersioningManager vmgr) throws ResourceException {
    this.resource = resource;
    this.vmgr = vmgr;
  }

  public void enable(IResourceList modifiedResources) throws ResourceException {
    this.invalidatePropertyCache();
    this.vmgr.enableAutoChildVersioning(modifiedResources, this.resource);
  }

  public void disable(boolean disableChildVersioning) throws ResourceException {
    this.invalidatePropertyCache();
    this.vmgr.disableAutoChildVersioning(disableChildVersioning, this.resource);
  }

  public boolean isEnabled() throws ResourceException {
    return this.vmgr.isAutoChildVersioningEnabled(this.resource);
  }

  private void invalidatePropertyCache() {
    ResourceImpl theImpl = null;
    if (this.resource instanceof CollectionLinkImpl) {
      theImpl = ((CollectionLinkImpl)this.resource).getLinkResourceImpl();
    }
    else {
      theImpl = (ResourceImpl)this.resource;
    }
    ResourcePropertyCacheHandler.removeCachedPrefilledProperties(theImpl, PropertyName.createEnhancedCollection());
  }
}
