package com.sapportals.wcm.repository;

/**
 * Tool class that is used by XXXImpl classes to handle property caching.
 */
public class ResourcePropertyCacheHandler {

	public static class PrefilledProperty {
		IProperty property;
		PrefilledProperty(IProperty p) {
			property = p;
		}
	}

	public static void setPrefilledProperty(ResourceImpl res, IProperty prop) {
		if (prop == null)
			return;
		synchronized (res.cachedPrefilledProperties) {
			PrefilledProperty p = (PrefilledProperty) res.cachedPrefilledProperties.get(prop.getPropertyName());
			if (p == null) {
				res.cachedPrefilledProperties.put(prop.getPropertyName(), new PrefilledProperty(prop));
			}
			else {
				p.property = prop;
			}
		}
	}

	public static void setCachedPrefilledProperties(ResourceImpl res, IPropertyMap newProps) {
		if (newProps == null) {
			synchronized (res.cachedPrefilledProperties) {
				res.cachedPrefilledProperties.clear();
			}
			return;
		}
		IPropertyIterator i = newProps.iterator();
		while (i.hasNext()) {
			IProperty prop = i.next();
			synchronized (res.cachedPrefilledProperties) {
				PrefilledProperty p = (PrefilledProperty) res.cachedPrefilledProperties.get(prop.getPropertyName());
				if (p == null) {
					res.cachedPrefilledProperties.put(prop.getPropertyName(), new PrefilledProperty(prop));
				}
				else {
					p.property = prop;
				}
			}
		}
	}

	public static void setCachedPrefilledProperty(ResourceImpl res, IPropertyName propName, IProperty prop) {
		if (propName == null)
			return;
		synchronized (res.cachedPrefilledProperties) {
			PrefilledProperty p = (PrefilledProperty) res.cachedPrefilledProperties.get(propName);
			if (p == null) {
				res.cachedPrefilledProperties.put(propName, new PrefilledProperty(prop));
			}
			else {
				p.property = prop;
			}
		}
	}

	public static PrefilledProperty getCachedPrefilledProperty(ResourceImpl res, IPropertyName propName) {
		if (propName == null)
			return null;
		synchronized (res.cachedPrefilledProperties) {
			return (PrefilledProperty) res.cachedPrefilledProperties.get(propName);
		}
	}

	public static void removeCachedPrefilledProperties(ResourceImpl res, IPropertyName propName) {
		if (propName == null)
			return;
		synchronized (res.cachedPrefilledProperties) {
			res.cachedPrefilledProperties.remove(propName);
		}
	}

	public static void removeCachedPrefilledProperties(ResourceImpl res, IPropertyMap props) {
		if (props == null)
			return;
		IPropertyIterator iterator = props.iterator();
		synchronized (res.cachedPrefilledProperties) {
			while (iterator.hasNext()) {
				res.cachedPrefilledProperties.remove(iterator.next().getPropertyName());
			}
		}
	}

	public static void removeCachedPrefilledContentProperties(ResourceImpl res) {
		ResourcePropertyCacheHandler.removeCachedPrefilledProperties(res, PropertyName.createContentType());
		ResourcePropertyCacheHandler.removeCachedPrefilledProperties(res, PropertyName.createContentLanguage());
		ResourcePropertyCacheHandler.removeCachedPrefilledProperties(res, PropertyName.createContentLength());
		ResourcePropertyCacheHandler.removeCachedPrefilledProperties(res, PropertyName.createETag());
	}

	public static void clearCachedPrefilledProperties(ResourceImpl res) {
		synchronized (res.cachedPrefilledProperties) {
			res.cachedPrefilledProperties.clear();
		}
	}

}