/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.repository.manager.IExtendedNamespaceManager;
import com.sapportals.wcm.repository.manager.IExtendedVersioningManager;
import com.sapportals.wcm.util.uri.IRidSet;

/**
 * Resource meta data object impl. <p>
 *
 * Copyright (c) SAP AG 2002-2003
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: ResourceMetadataImpl.java,v 1.3 2003/02/17 14:24:04 jre Exp $
 */

public final class ResourceMetadataImpl implements IResourceMetadata {

  private final IResource resource;
  private final IExtendedNamespaceManager mgr;
  private final IExtendedVersioningManager vmgr;

  public ResourceMetadataImpl(IResource resource, IExtendedNamespaceManager mgr,
    IExtendedVersioningManager vmgr)
    throws ResourceException {
    this.resource = resource;
    this.mgr = mgr;
    this.vmgr = vmgr;
  }

  public IRidSet getVersionHistoryCollectionSet()
    throws ResourceException {
    return this.vmgr.getVersionHistoryCollectionSet(resource);
  }

  public IRidSet getWorkspaceCollectionSet()
    throws ResourceException {
    return this.vmgr.getWorkspaceCollectionSet(resource);
  }

}
