/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import java.util.List;

import com.sap.netweaver.bc.rf.common.IResourceHandle;
import com.sap.netweaver.bc.rf.mi.AbstractManager;
import com.sap.netweaver.bc.rf.mi.content.IContentManager;
import com.sap.netweaver.bc.rf.mi.lock.ILockManager;
import com.sap.netweaver.bc.rf.mi.namespace.INamespaceManager;
import com.sap.netweaver.bc.rf.mi.property.IPropertyManager;
import com.sap.netweaver.bc.rf.mi.security.ISecurityManager;
import com.sap.netweaver.bc.rf.mi.version.IBasicVersioningManager;
import com.sapportals.wcm.repository.enum.LinkType;
import com.sapportals.wcm.repository.manager.IRepositoryManager;
import com.sapportals.wcm.util.content.IContent;
import com.sapportals.wcm.util.uri.RID;
import com.sapportals.wcm.util.uri.URL;

/**
 * Framework resource implementation for new repository manager interfaces
 */
public class ResourceImpl2 extends ResourceImpl {

  // ---------------------------------------------------------------------------
  // Constructors
  // ---------------------------------------------------------------------------


  /**
   * Construct new framework internal resource implementation.
   *
   * @param handle TBD: Description of the incoming method parameter
   * @param manager TBD: Description of the incoming method parameter
   * @param context TBD: Description of the incoming method parameter
   * @exception ResourceException Exception raised in failure situation
   */
  ResourceImpl2(IResourceHandle handle, AbstractManager manager, IResourceContext context)
    throws ResourceException {
    super(handle, manager, context);
    RMAdapter.createAccessContext(context);
  }


  // ---------------------------------------------------------------------------
  // General
  // ---------------------------------------------------------------------------


  /**
   * Returns the namespace manager for this resource.
   *
   * @param required throw NotSupportedException if the sub-manager is not
   *      available.
   * @return the namespace manager for this resource.
   * @exception NotSupportedException Exception raised in failure situation
   * @exception ResourceException Exception raised in failure situation
   */
  protected final INamespaceManager getNamespaceManager2(boolean required)
    throws NotSupportedException, ResourceException {
    return GeneralImpl2.getNamespaceManager2(this, required);
  }


  /**
   * Returns the lock manager for this resource.
   *
   * @param required throw NotSupportedException if the sub-manager is not
   *      available.
   * @return the lock manager for this resource.
   * @exception NotSupportedException Exception raised in failure situation
   * @exception ResourceException Exception raised in failure situation
   */
  protected final ILockManager getLockManager2(boolean required)
    throws NotSupportedException, ResourceException {
    return GeneralImpl2.getLockManager2(this, required);
  }


  /**
   * Returns the property manager for this resource.
   *
   * @param required throw NotSupportedException if the sub-manager is not
   *      available.
   * @return the property manager for this resource.
   * @exception NotSupportedException Exception raised in failure situation
   * @exception ResourceException Exception raised in failure situation
   */
  protected final IPropertyManager getPropertyManager2(boolean required)
    throws NotSupportedException, ResourceException {
    return GeneralImpl2.getPropertyManager2(this, required);
  }


  /**
   * Returns the versioning manager for this resource.
   *
   * @param required throw NotSupportedException if the sub-manager is not
   *      available.
   * @return the versioning manager for this resource.
   * @exception NotSupportedException Description of Exception
   * @exception ResourceException Description of Exception
   */
  protected final IBasicVersioningManager getBasicVersioningManager(boolean required)
    throws NotSupportedException, ResourceException {
    return GeneralImpl2.getBasicVersioningManager(this, required);
  }


  /**
   * Returns the security manager for this resource.
   *
   * @param required throw NotSupportedException if the sub-manager is not
   *      available.
   * @return the security manager for this resource.
   * @exception NotSupportedException Exception raised in failure situation
   * @exception ResourceException Exception raised in failure situation
   */
  protected final ISecurityManager getSecurityManager2(boolean required)
    throws NotSupportedException, ResourceException {
    return GeneralImpl2.getSecurityManager2(this, required);
  }


  /**
   * Returns the content manager for this resource.
   *
   * @param required throw NotSupportedException if the sub-manager is not
   *      available.
   * @return the content manager for this resource.
   * @exception NotSupportedException Description of Exception
   * @exception ResourceException Description of Exception
   */
  protected final IContentManager getContentManager2(boolean required)
    throws NotSupportedException, ResourceException {
    return GeneralImpl2.getContentManager2(this, required);
  }


  protected void internalRename(String newName)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalRename(this, newName);
  }


  protected void internalDeleteProperty(IPropertyName propName)
    throws ResourceException,
    NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalDeleteProperty(this, propName);
  }


  protected void internalSetTargetURL(URL url)
    throws ResourceException, AccessDeniedException {
    GeneralImpl2.internalSetTargetURL(this, url);
  }


  protected void internalSetLinkType(LinkType linkType)
    throws ResourceException, AccessDeniedException {
    GeneralImpl2.internalSetLinkType(this, linkType);
  }


  protected IProperty internalGetProperty(IPropertyName propName)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    return GeneralImpl2.internalGetProperty(this, propName);
  }


  protected IPropertyMap internalGetProperties()
    throws ResourceException, NotSupportedException, AccessDeniedException {
    return GeneralImpl2.internalGetProperties(this);
  }

  protected IPropertyMap internalGetProperties(IPropertyNameList list)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    return GeneralImpl2.internalGetProperties(list, this);
  }

  protected void internalSetProperties(IPropertyMap props)
    throws ResourceException, NotSupportedException,
    AccessDeniedException, SetPropertiesException {
    GeneralImpl2.internalSetProperties(this, props);
  }


  protected void internalSetProperties(List propChangeList)
    throws ResourceException, NotSupportedException,
    AccessDeniedException, SetPropertiesException {
    GeneralImpl2.internalSetProperties(this, propChangeList);
  }


  protected void internalSetProperty(IProperty prop)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalSetProperty(this, prop);
  }


  protected void internalUpdateContent(IContent newContent)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalUpdateContent(this, newContent);
  }

  protected void internalUpdate(IContent newContent, IPropertyMap properties)
    throws ResourceException, NotSupportedException, AccessDeniedException, SetPropertiesException {
    GeneralImpl2.internalUpdate(this, newContent, properties);
  }

  protected void internalDelete()
    throws ResourceException, NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalDelete(this);
  }


  protected URL internalGetTargetURL()
    throws ResourceException {
    return GeneralImpl2.internalGetTargetURL(this);
  }


  protected LinkType internalGetLinkType()
    throws ResourceException {
    return GeneralImpl2.internalGetLinkType(this);
  }


  protected IResource internalCopyManager(RID destinationRID, IPosition position, ICopyParameter param)
    throws ResourceException {
    return GeneralImpl2.internalCopyManager(this, destinationRID, position, param);
  }


  protected IResource internalMoveManager(RID destinationRID, IPosition position, ICopyParameter param)
    throws ResourceException {
    return GeneralImpl2.internalMoveManager(this, destinationRID, position, param);
  }


  protected void internalChangePosision(IPosition pos)
    throws ResourceException {
    GeneralImpl2.internalChangePosision(this, pos);
  }


  protected ILockInfo internalLock(ILockProperties lockProperties)
    throws ResourceException,
    NotSupportedException, AccessDeniedException {
    return GeneralImpl2.internalLock(this, lockProperties);
  }


  protected void internalUnlock(ILockInfo lockInfo)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalUnlock(this, lockInfo);
  }


  protected void internalRefreshLock(ILockInfo lockInfo)
    throws ResourceException,
    NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalRefreshLock(this, lockInfo);
  }


  protected ILockInfo internalGetLockByToken(String lockToken)
    throws ResourceException, NotSupportedException {
    return GeneralImpl2.internalGetLockByToken(this, lockToken);
  }


  protected ILockInfoCollection internalGetLocks()
    throws ResourceException, NotSupportedException, AccessDeniedException {
    return GeneralImpl2.internalGetLocks(this);
  }


  protected boolean internalIsLocked()
    throws ResourceException {
    return GeneralImpl2.internalIsLocked(this);
  }


  protected boolean internalIsLockedByMe()
    throws ResourceException {
    return GeneralImpl2.internalIsLockedByMe(this);
  }

  protected IContent internalGetContent(boolean handleExternalLink)
    throws ResourceException, AccessDeniedException {
    if (handleExternalLink) {
      throw new NotSupportedException();
    }
    if (this.content == null) {
      this.content = new ContentImpl2(this, true);
    }
    return this.content;
  }

  protected IContent internalGetUnfilteredContent(boolean handleExternalLink)
    throws ResourceException, AccessDeniedException {
    if (handleExternalLink) {
      throw new NotSupportedException();
    }
    if (this.unfilteredContent == null) {
      this.unfilteredContent = new ContentImpl2(this, false);
    }
    return this.unfilteredContent;
  }

  protected boolean internalIsCheckedOut()
    throws ResourceException {
    return GeneralImpl2.internalIsCheckedOut(this);
  }

  protected ICheckOutInfo internalCheckOut()
    throws ResourceException, NotSupportedException, AccessDeniedException {
    return GeneralImpl2.internalCheckOut(this);
  }


  protected void internalUndoCheckOut()
    throws ResourceException, NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalUndoCheckOut(this);
  }


  protected ICheckInInfo internalCheckIn(IContent newContent, IPropertyMap properties,
    boolean ignorePropertyFailures, RID expectedCheckInRID)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    return GeneralImpl2.internalCheckIn(this, newContent, properties, ignorePropertyFailures, expectedCheckInRID);
  }


  protected IVersionHistory internalGetVersionHistory()
    throws ResourceException, NotSupportedException {
    return GeneralImpl2.internalGetVersionHistory(this);
  }


  protected IResourceList internalGetCheckedOutResources()
    throws ResourceException, NotSupportedException, AccessDeniedException {
    return GeneralImpl2.internalGetCheckedOutResources(this);
  }


  protected void internalEnableVersioning(boolean enable)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalEnableVersioning(this, enable);
  }


  protected boolean internalIsVersioned()
    throws ResourceException {
    return GeneralImpl2.internalIsVersioned(this);
  }
  
     
  // ----------------------------------------------------------------------------
  // Overwrite other public methods in ResourceImpl for access context handling
  // which will or might result in a call to the repository manager.
  // ----------------------------------------------------------------------------
 
  public ISupportedOptionSet getSupportedOptions() {
    RMAdapter.checkAndCreateAccessContext(this.getContext());     
    return super.getSupportedOptions();
  }
  public IRepositoryManager getRepositoryManager() {
    RMAdapter.checkAndCreateAccessContext(this.getContext());     
    return super.getRepositoryManager();
  }  

}
