package com.sapportals.wcm.repository;

import javax.servlet.http.*;

/**
 * ONLY FOR INTERNAL USE !!!
 * <p>
 * Copyright (c) SAP AG 2001-2002
 * @author frank.renkes@sap.com
 * @version $Id:$
 */
public class RFStatisticCounter {

  private static com.sap.tc.logging.Location log = com.sap.tc.logging.Location.getLocation(RFStatisticCounter.class.getName());

  private final static String HTTP_KM_SERVER_RFC_GETC1 = "km_server_rfgc1";

  // timer when request is started
  private static ThreadLocal gcfst = new ThreadLocal() {
    protected synchronized Object initialValue() {
      return new Long(0);
    }
  };

  private static ThreadLocal gcfsc = new ThreadLocal() {
    protected synchronized Object initialValue() {
      return new Long(0);
    }
  };

  synchronized public static void initCounter() {
    gcfst.set(new Long(0));
    gcfsc.set(new Long(0));
  }

  public static Long getChildrenFilterAndSortTimer() {
    return ((Long) (gcfst.get()));
  }

  public static Long getChildrenFilterAndSortCounter() {
    return ((Long) (gcfsc.get()));
  }

  synchronized public static void increaseGetChildrenFilterAndSortTimer(long time) {
    Long t = getChildrenFilterAndSortTimer();
    Long c = getChildrenFilterAndSortCounter();
    gcfst.set(new Long(t.longValue() + time));
    gcfsc.set(new Long(c.longValue() + 1));
  }

  public static void write(HttpServletResponse resp) {

    Long gct = (Long)getChildrenFilterAndSortTimer();
    Long gcc = (Long)getChildrenFilterAndSortCounter();

    if (null != gct) {
      resp.setHeader(HTTP_KM_SERVER_RFC_GETC1, gcc.toString() + "," + gct.toString());
    }
  }
}
