/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.IFrameworkTransaction;
import com.sapportals.wcm.repository.manager.IExtendedNamespaceManager;
import com.sapportals.wcm.util.uri.IUri;
import com.sapportals.wcm.util.uri.UriFactory;

/**
 * Orderable Collection impl. <p>
 *
 * Copyright (c) SAP AG 2003
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: OrderableCollectionImpl.java,v 1.1 2003/01/31 15:57:44 jre Exp
 *      $
 */

public final class OrderableCollectionImpl implements IOrderableCollection {

  private final ICollection collection;
  private final IExtendedNamespaceManager mgr;

  public final static IUri UNORDERED;
  public final static IUri CUSTOM;

  static {
    try {
      IUri tmp = UriFactory.parseUri("DAV:unordered");
      UNORDERED = tmp;
      tmp = UriFactory.parseUri("DAV:custom");
      CUSTOM = tmp;
    }
    catch (java.net.MalformedURLException ex) {
      throw new RuntimeException(ex.getMessage());
    }
  }

  public OrderableCollectionImpl(ICollection collection, IExtendedNamespaceManager mgr)
    throws ResourceException {
    this.collection = collection;
    this.mgr = mgr;
  }

  public IUri getOrderingType()
    throws ResourceException {
    return this.mgr.getOrderingType(this.collection);
  }

  public void setOrderingType(IUri orderingType)
    throws ResourceException {
    IFrameworkTransaction ft = FrameworkTransaction.required();
    try {
      this.mgr.setOrderingType(orderingType, this.collection);
      ft.commit();
      ft = null;
    }
    finally {
      if (ft != null) ft.rollback();
    }
  }
}
