package com.sapportals.wcm.repository;

import java.sql.SQLException;

//J2EE Transaction
//import javax.transaction.Status;
//import com.sap.transaction.TransactionTicket;
//import com.sap.transaction.TxException;
//import com.sap.transaction.TxManager;

import com.sap.tc.logging.Location;
import com.sapportals.wcm.IFrameworkTransaction;
import com.sapportals.wcm.ITransactionEndsListener;

/**
 * <p>
 * Copyright (c) SAP AG 2004
 * @author martin.boettcher@greenbytes.de
 * @author michael.koeller@greenbytes.de
 */
public class J2EETransaction extends FrameworkTransaction {
  private static final Location log = Location.getLocation(FrameworkTransaction.class);
  
//  private TransactionTicket ticket = null;
  
  protected J2EETransaction() throws ResourceException {
    if (log.beDebug()) log.debugT("creating j2ee transaction ...");
/*    
    if (this.orgTransaction == null) {        
      try{
        this.ticket = TxManager.required();
      }
      catch(TxException e) {
        log.errorT("can't get framework transaction - " + e);
        throw new ResourceException(e);
      }
    }
*/
    if (log.beDebug()) log.debugT("... created j2ee transaction");
  }
  
/*  
  public void addEndListener(ITransactionEndsListener listener) throws ResourceException {
    String key = listener.getKey();
    if (this.orgTransaction == null) {
      try{
        TxManager.registerSynchronization(key, new TransactionWrapper(listener, this));
      }
      catch(TxException e) {
        log.errorT("can't register sync object with key '" + key + "' - " + e);
        throw new ResourceException(e);
      }
    }
    else
      this.orgTransaction.addEndListener(listener);
  }

  public boolean isEndListenerRegistered(ITransactionEndsListener listener) {
    String key = listener.getKey();
    try {
      return TxManager.isTxActive() && (TxManager.getRegisteredSynchronization(key) != null);
    }
    catch(TxException e) {
      log.errorT("can't look up sync object with key '" + key + "' - " + e);
    }
    return false;
  }
  
  public ITransactionEndsListener getEndListener(String key) {
    if (this.orgTransaction != null) {
      return this.orgTransaction.getEndListener(key);
    }
    
    try {
      if (TxManager.isTxActive()) {
        TransactionWrapper w = (TransactionWrapper) TxManager.getRegisteredSynchronization(key);
        if (w != null) {
          return w.getListener();
        }
      }
    }
    catch (TxException e) {
      log.errorT("can't look up sync object with key '" + key + "' - " + e);
    }
    return null;
  }
  
  protected boolean closeConnection(boolean commit) {        
    if (this.orgTransaction != null) return !this.willBeRollbacked();
    
    boolean ok = true;
    try{
      this.invalidate();
      
      if (commit)
        TxManager.commitLevel(this.ticket);
      else
        TxManager.setRollbackOnly();
      
      if (this.con != null) this.con.close();
      this.con = null;
    }
    catch(Exception e) {
      ok = false;      
    }
    finally{
      try{
        if (this.ticket != null) TxManager.leaveLevel(this.ticket);
      }
      catch(TxException e) {
        log.errorT("can't leave level of J2EE transaction - " + e);            
      }
      this.ticket = null;
      
      if (this.con != null) {
        try{
          this.con.rollback();
        }
        catch(SQLException e) {
          if (log.beWarning()) log.warningT("can't rollback connection." + e.getMessage());
        }
        try{
          this.con.close();
        }
        catch(SQLException e) {
          if (log.beWarning()) log.warningT("can't close connection." + e.getMessage());
        }
        this.con = null;
        ok = false;
      }
    }
    
    return ok;
  }
  
  public void setVeto() {    
    try{
      TxManager.setRollbackOnly();
    }
    catch(TxException e) {
      log.errorT("can't set rollbackonly on j2ee transaction - " + e);
    }
    super.setVeto();
  }
  
  public boolean willBeRollbacked() {
    boolean ret = super.willBeRollbacked();
    try{
      ret = TxManager.isTxMarkedRollback();
    }
    catch(TxException e) {
      log.errorT("can't retrieve rollback info on j2ee transaction - " + e);
    }
    return ret;    
  }
      
  private class TransactionWrapper implements javax.transaction.Synchronization {
    private ITransactionEndsListener l;
    private IFrameworkTransaction context;
    
    public TransactionWrapper(ITransactionEndsListener l, IFrameworkTransaction t) {
      this.l = l;
      this.context = t;
    }
    
    public ITransactionEndsListener getListener() {
      return this.l;
    }
    
    public void beforeCompletion() {
      //we do not need to implement this method
    }      
        
    public void afterCompletion(int status) {      
      if (status == Status.STATUS_COMMITTED) { 
        this.l.wasCommitted(this.context);        
      }
      else if (status == Status.STATUS_ROLLEDBACK) {
        this.l.wasRolledback(this.context);
      }
      
    }
  }
*/  
}
