/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.repository.manager.IExtendedNamespaceManager;
import com.sapportals.wcm.util.uri.RID;

/**
 * Internal link resource object impl. <p>
 *
 * Copyright (c) SAP AG 2002-2003
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: InternalLinkResourceImpl.java,v 1.4 2003/01/08 16:37:52 jre Exp
 *      $
 */

public class InternalLinkResourceImpl implements IInternalLinkResource {

  private final IResource resource;
  private final IExtendedNamespaceManager nsmgr;

  public InternalLinkResourceImpl(IResource resource, IExtendedNamespaceManager nsmgr)
    throws ResourceException {
    this.resource = resource;
    this.nsmgr = nsmgr;
  }

  public IResource getTargetResource()
    throws ResourceException {
    return ResourceFactory.getInstance().getResource(getTargetRID(), this.resource.getContext());
  }

  public RID getTargetRID()
    throws ResourceException {
    return this.nsmgr.getTargetRID(this.resource);
  }

  public void setTargetRID(RID target)
    throws ResourceException {
    this.nsmgr.setTargetRID(target, this.resource);
  }

  public boolean isDynamic()
    throws ResourceException {
    return this.nsmgr.isDynamicInternalLink(this.resource);
  }

  public boolean isPermanent()
    throws ResourceException {
    return this.nsmgr.isPermanentLink(this.resource);
  }

}
