/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.repository.manager.IExtendedNamespaceManager;
import com.sapportals.wcm.util.uri.IUri;

/**
 * External link resource object impl. <p>
 *
 * Copyright (c) SAP AG 2002-2003
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: ExternalLinkResourceImpl.java,v 1.3 2003/01/08 16:37:52 jre Exp
 *      $
 */

public class ExternalLinkResourceImpl implements IExternalLinkResource {

  private final IResource resource;
  private final IExtendedNamespaceManager nsmgr;

  public ExternalLinkResourceImpl(IResource resource, IExtendedNamespaceManager nsmgr)
    throws ResourceException {
    this.resource = resource;
    this.nsmgr = nsmgr;
  }

  public IUri getTargetUri()
    throws ResourceException {
    return this.nsmgr.getTargetUri(this.resource);
  }

  public void setTargetUri(IUri target)
    throws ResourceException {
    this.nsmgr.setTargetUri(target, this.resource);
  }

  public boolean isPermanent()
    throws ResourceException {
    return this.nsmgr.isPermanentLink(this.resource);
  }
}
