/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import com.sapportals.wcm.repository.wrapping.content.*;
import com.sapportals.wcm.repository.wrapping.exception.ExceptionTransformer;

import com.sapportals.wcm.util.content.*;

/**
 * Access to the content data of a resource. <p>
 *
 * Copyright (c) SAP AG 2001-2004
 */
public final class ContentImpl2 extends ContentImpl {

  public ContentImpl2(ResourceImpl2 resource, boolean useFilter) throws ResourceException {
    super(resource, useFilter);
  }

  public ContentImpl2(CollectionImpl2 collection, boolean useFilter) throws ResourceException {
    super(collection, useFilter);
  }

  protected IContent internalGetContent()
    throws ResourceException {
    try {
      if (this.resource instanceof ResourceImpl2) {
        return ContentTransformer.transform(((ResourceImpl2)this.resource).getContentManager2(true).getContent(this.resource.getHandle()));
      }
      else {
        return ContentTransformer.transform(((CollectionImpl2)this.resource).getContentManager2(true).getContent(this.resource.getHandle()));
      }
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException ex) {
      throw ExceptionTransformer.transform(ex);
    }
  }
}
