/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;
import com.sapportals.wcm.WcmException;

import com.sapportals.wcm.WcmObject;
import com.sapportals.wcm.util.content.ContentException;
import com.sapportals.wcm.util.mmparser.HeaderFields;
import com.sapportals.wcm.util.urlcontentaccess.IProtocolPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/**
 * Title: WCM Dev Description: Copyright (c) SAP Portals Europe GmbH 2001
 * Company: SAP AG
 *
 * @author RP
 * @version 1.0
 */

public class ContentAccessPlugin extends WcmObject implements IProtocolPlugin {
  private IResource m_resource = null;

  public ContentAccessPlugin() { }

  public void init(String url)
    throws IOException {
    try {
      if (url.startsWith("//")) {
        m_resource = ResourceFactory.getInstance().getResource(new com.sapportals.wcm.util.uri.URI(url.substring(1)), new ResourceContext(null));
      }
      else {
        m_resource = ResourceFactory.getInstance().getResource(new com.sapportals.wcm.util.uri.URI(url), new ResourceContext(null));
      }
      if (m_resource == null) {
        throw new IOException("Resource not found:" + url);
      }
    }
    catch (ResourceException e) {
      throw new IOException(e.getMessage());
    }
  }

  public InputStream getInputStream()
    throws IOException {
    try {
      return m_resource.getUnfilteredContent().getInputStream();
    }
    catch (ResourceException e) {
      throw new IOException(e.getMessage());
    }
    catch (ContentException e) {
      throw new IOException(e.getMessage());
    }
  }

  public HeaderFields getHeaderFields()
    throws IOException {
    HeaderFields hf = new HeaderFields();
    return hf;
  }
}
