/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.repository.manager.IExtendedNamespaceManager;
import com.sapportals.wcm.repository.manager.IExtendedVersioningManager;
import com.sapportals.wcm.util.uri.IUri;

import java.util.Map;

/**
 * Version resource object implementation. <p>
 *
 * Copyright (c) SAP AG 2002-2003
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: CollectionVersionResourceImpl.java,v 1.3 2003/02/17 14:24:03
 *      jre Exp $
 */

public final class CollectionVersionResourceImpl implements ICollectionVersionResource {

  private final IResource resource;
  private final IExtendedVersioningManager vmgr;
  private final IExtendedNamespaceManager nmgr;

  public CollectionVersionResourceImpl(
    IResource resource, IExtendedVersioningManager vmgr, IExtendedNamespaceManager nmgr)
    throws ResourceException {

    this.resource = resource;
    this.vmgr = vmgr;
    this.nmgr = nmgr;
  }

  public Map getVersionControlledBindingSet()
    throws ResourceException {
    return this.vmgr.getVersionControlledBindingSet(this.resource);
  }

  public IUri getOrderingType()
    throws ResourceException {
    return this.nmgr.getOrderingType(this.resource);
  }
}
