/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import java.net.MalformedURLException;
import java.util.Iterator;
import java.util.List;

import com.sap.netweaver.bc.rf.common.IResourceHandle;
import com.sap.netweaver.bc.rf.common.Rid;
import com.sap.netweaver.bc.rf.common.namespace.*;
import com.sap.netweaver.bc.rf.mi.AbstractManager;
import com.sap.netweaver.bc.rf.mi.content.IContentManager;
import com.sap.netweaver.bc.rf.mi.lock.ILockManager;
import com.sap.netweaver.bc.rf.mi.namespace.IMutableNamespaceManager;
import com.sap.netweaver.bc.rf.mi.namespace.INamespaceManager;
import com.sap.netweaver.bc.rf.mi.property.IPropertyManager;
import com.sap.netweaver.bc.rf.mi.security.ISecurityManager;
import com.sap.netweaver.bc.rf.mi.version.IBasicVersioningManager;
import com.sapportals.wcm.repository.enum.LinkType;
import com.sapportals.wcm.repository.enum.OrderType;
import com.sapportals.wcm.repository.manager.IRepositoryManager;
import com.sapportals.wcm.repository.wrapping.content.ContentTransformer;
import com.sapportals.wcm.repository.wrapping.exception.ExceptionTransformer;
import com.sapportals.wcm.repository.wrapping.exception.IncompleteOperationTransformer;
import com.sapportals.wcm.repository.wrapping.lock.LockDescriptorTransformer;
import com.sapportals.wcm.repository.wrapping.lock.LockInfoTransformer;
import com.sapportals.wcm.repository.wrapping.namespace.OrderMechanismTransformer;
import com.sapportals.wcm.repository.wrapping.namespace.OrderPositionTransformer;
import com.sapportals.wcm.repository.wrapping.property.PropertyTransformer;
import com.sapportals.wcm.util.content.IContent;
import com.sapportals.wcm.util.uri.IRidList;
import com.sapportals.wcm.util.uri.RID;
import com.sapportals.wcm.util.uri.URL;

/**
 * Framework resource implementation for new repository manager interfaces
 *
 */
public class CollectionImpl2 extends CollectionImpl {

  // ---------------------------------------------------------------------------
  // Constructors
  // ---------------------------------------------------------------------------

  /**
   * Construct new framework internal collection implementation.
   */
  CollectionImpl2(IResourceHandle handle, AbstractManager manager, IResourceContext context) throws ResourceException {
    super(handle, manager, context);
    RMAdapter.createAccessContext(context);
  }

  // ---------------------------------------------------------------------------
  // General
  // ---------------------------------------------------------------------------

  /**
   * Returns the namespace manager for this resource.
   *
   * @param required throw NotSupportedException if the sub-manager is not
   *      available.
   * @return the namespace manager for this resource.
   */
  protected final INamespaceManager getNamespaceManager2(boolean required)
    throws NotSupportedException, ResourceException {
    return GeneralImpl2.getNamespaceManager2(this, required);
  }

  /**
   * Returns the lock manager for this resource.
   *
   * @param required throw NotSupportedException if the sub-manager is not
   *      available.
   * @return the lock manager for this resource.
   */
  protected final ILockManager getLockManager2(boolean required) throws NotSupportedException, ResourceException {
    return GeneralImpl2.getLockManager2(this, required);
  }

  /**
   * Returns the property manager for this resource.
   *
   * @param required throw NotSupportedException if the sub-manager is not
   *      available.
   * @return the property manager for this resource.
   */
  protected final IPropertyManager getPropertyManager2(boolean required)
    throws NotSupportedException, ResourceException {
    return GeneralImpl2.getPropertyManager2(this, required);
  }

  /**
   * Returns the versioning manager for this resource.
   *
   * @param required throw NotSupportedException if the sub-manager is not
   *      available.
   * @return the versioning manager for this resource.
   */
  protected final IBasicVersioningManager getBasicVersioningManager(boolean required)
    throws NotSupportedException, ResourceException {
    return GeneralImpl2.getBasicVersioningManager(this, required);
  }

  /**
   * Returns the security manager for this resource.
   *
   * @param required throw NotSupportedException if the sub-manager is not
   *      available.
   * @return the security manager for this resource.
   */
  protected final ISecurityManager getSecurityManager2(boolean required)
    throws NotSupportedException, ResourceException {
    return GeneralImpl2.getSecurityManager2(this, required);
  }

  /**
   * Returns the content manager for this resource.
   *
   * @param required throw NotSupportedException if the sub-manager is not
   *      available.
   * @return the content manager for this resource.
   */
  protected final IContentManager getContentManager2(boolean required)
    throws NotSupportedException, ResourceException {
    return GeneralImpl2.getContentManager2(this, required);
  }

  protected IContent internalGetContent(boolean handleExternalLink) throws ResourceException, AccessDeniedException {
    if (this.content == null) {
      this.content = new ContentImpl2(this, true);
    }
    return this.content;
  }

  protected void internalRename(String newName)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalRename(this, newName);
  }

  protected void internalDeleteProperty(IPropertyName propName)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalDeleteProperty(this, propName);
  }

  protected void internalSetTargetURL(URL url) throws ResourceException, AccessDeniedException {
    GeneralImpl2.internalSetTargetURL(this, url);
  }

  protected void internalSetLinkType(LinkType linkType) throws ResourceException, AccessDeniedException {
    GeneralImpl2.internalSetLinkType(this, linkType);
  }

  protected IProperty internalGetProperty(IPropertyName propName)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    return GeneralImpl2.internalGetProperty(this, propName);
  }

  protected IPropertyMap internalGetProperties()
    throws ResourceException, NotSupportedException, AccessDeniedException {
    return GeneralImpl2.internalGetProperties(this);
  }

  protected IPropertyMap internalGetProperties(IPropertyNameList list)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    return GeneralImpl2.internalGetProperties(list, this);
  }

  protected void internalSetProperties(IPropertyMap props)
    throws ResourceException, NotSupportedException, AccessDeniedException, SetPropertiesException {
    GeneralImpl2.internalSetProperties(this, props);
  }

  protected void internalSetProperties(List propChangeList)
    throws ResourceException, NotSupportedException, AccessDeniedException, SetPropertiesException {
    GeneralImpl2.internalSetProperties(this, propChangeList);
  }

  protected void internalSetProperty(IProperty prop)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalSetProperty(this, prop);
  }

  protected void internalUpdateContent(IContent newContent)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalUpdateContent(this, newContent);
  }

  protected void internalDelete() throws ResourceException, NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalDelete(this);
  }

  protected URL internalGetTargetURL() throws ResourceException {
    return GeneralImpl2.internalGetTargetURL(this);
  }

  protected LinkType internalGetLinkType() throws ResourceException {
    return GeneralImpl2.internalGetLinkType(this);
  }

  protected IResource internalCopyManager(RID destinationRID, IPosition position, ICopyParameter param)
    throws ResourceException {
    return GeneralImpl2.internalCopyManager(this, destinationRID, position, param);
  }

  protected IResource internalMoveManager(RID destinationRID, IPosition position, ICopyParameter param)
    throws ResourceException {
    return GeneralImpl2.internalMoveManager(this, destinationRID, position, param);
  }

  protected void internalChangePosision(IPosition pos) throws ResourceException {
    GeneralImpl2.internalChangePosision(this, pos);
  }

  protected ILockInfo internalLock(ILockProperties lockProperties)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    return GeneralImpl2.internalLock(this, lockProperties);
  }

  protected void internalUnlock(ILockInfo lockInfo)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalUnlock(this, lockInfo);
  }

  protected void internalRefreshLock(ILockInfo lockInfo)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalRefreshLock(this, lockInfo);
  }

  protected ILockInfo internalGetLockByToken(String lockToken) throws ResourceException, NotSupportedException {
    return GeneralImpl2.internalGetLockByToken(this, lockToken);
  }

  protected ILockInfoCollection internalGetLocks()
    throws ResourceException, NotSupportedException, AccessDeniedException {
    return GeneralImpl2.internalGetLocks(this);
  }

  protected boolean internalIsLocked() throws ResourceException {
    return GeneralImpl2.internalIsLocked(this);
  }

  protected boolean internalIsLockedByMe() throws ResourceException {
    return GeneralImpl2.internalIsLockedByMe(this);
  }

  // ---------------------------------------------------------------------------
  // Collection Specifics
  // ---------------------------------------------------------------------------

  protected IResourceList internalGetChildrenManager() throws ResourceException {
    RMAdapter.checkAndCreateAccessContext(this.getContext());
    try {
      INamespaceManager nsMgr = this.getNamespaceManager2(true);
      List list = null;
//      boolean listSupported = true;
//      try {
        list = nsMgr.findResources(this.getHandle(), new BasicChildrenFindResourcesDescriptor(), 0, -1, null);
//     }
//      catch (OperationNotSupportedException ex) {
//        listSupported = false;
//      }

//      if (listSupported) {
        if (list != null) {
          IResourceList rl = new ResourceList();
          for (Iterator iter = list.iterator(); iter.hasNext();) {
            rl.add(RMAdapter.createResourceInstance(
              (IResourceHandle)iter.next(),
              this.rmAdapter.getNewAbstract(),
              this.getContext()));
          }
          return rl;
        }
        else {
          // MB: Is it really allowed for RM to return null ?
          return new ResourceList();
        }
//      }
//      else {
        // Rep. will (must) support findResource() method with Iterator instead
//        return new ResourceList2(
//          this,
//          nsMgr.findResources(this.getHandle(), new BasicChildrenFindResourcesDescriptor(), 0, -1));
//      }
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException exception) {
      throw ExceptionTransformer.transform(exception);
    }
  }

  protected IRidList internalDeleteCollectionManager() throws ResourceException {
    RMAdapter.checkAndCreateAccessContext(this.getContext());
    try {
      INamespaceManager nsm = this.getNamespaceManager2(true);
      if (!(nsm instanceof IMutableNamespaceManager)) {
        throw new NotSupportedException();
      }
      else {
        return IncompleteOperationTransformer.getRidList(
          ((IMutableNamespaceManager)nsm).deleteResource(this.getHandle()));
      }
    }
    catch (com.sap.netweaver.bc.rf.common.exception.OperationNotCompletedException exception) {
      throw IncompleteOperationTransformer.transform(exception);
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException exception) {
      throw ExceptionTransformer.transform(exception);
    }
  }

  protected OrderType internalGetOrderType() throws ResourceException {
    RMAdapter.checkAndCreateAccessContext(this.getContext());
    try {
      try {
        return OrderMechanismTransformer.transform(
          this.getNamespaceManager2(true).getCollectionOrderMechanism(this.getHandle()));
      }
      catch (NotSupportedException ex) {
        return OrderType.NONE;
      }
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException exception) {
      throw ExceptionTransformer.transform(exception);
    }
  }

  protected void internalSetOrderType(OrderType orderType)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    RMAdapter.checkAndCreateAccessContext(this.getContext());
    try {
      INamespaceManager nsm = this.getNamespaceManager2(true);
      if (!(nsm instanceof IMutableNamespaceManager)) {
        throw new NotSupportedException();
      }
      else {
        ((IMutableNamespaceManager)nsm).setCollectionOrderMechanism(
          this.getHandle(),
          OrderMechanismTransformer.transform(orderType));
      }
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException exception) {
      throw ExceptionTransformer.transform(exception);
    }
  }

  protected void internalReorder(IReorderList list)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    RMAdapter.checkAndCreateAccessContext(this.getContext());
    try {
      INamespaceManager nsm = this.getNamespaceManager2(true);
      if (!(nsm instanceof IMutableNamespaceManager)) {
        throw new NotSupportedException();
      }
      else {
        ((IMutableNamespaceManager)nsm).reorderCollection(this.getHandle(), OrderPositionTransformer.transform(list));
      }
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException exception) {
      throw ExceptionTransformer.transform(exception);
    }
  }

  protected ICollection internalCreateCollection(
    String name,
    IPosition position,
    IPropertyMap properties,
    boolean ignorePropertyFailures)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    RMAdapter.checkAndCreateAccessContext(this.getContext());
    try {
      INamespaceManager nsm = this.getNamespaceManager2(true);
      if (!(nsm instanceof IMutableNamespaceManager)) {
        throw new NotSupportedException();
      }
      else {
        ResourceCreateDescriptor desc =
          new CollectionCreateDescriptor(
            new com.sap.netweaver.bc.rf.common.namespace.DestinationDescriptor(
              this.getHandle().getRid(),
              name,
              OrderPositionTransformer.transform(position),
              false),
            new ContentAndPropertiesDescriptor(
              null,
              PropertyTransformer.transformToList(properties),
              ignorePropertyFailures));

        IResourceHandle newHandle = ((IMutableNamespaceManager)nsm).createResource(desc);
        CollectionImpl2 newRes = new CollectionImpl2(newHandle, this.rmAdapter.getNewAbstract(), this.getContext());
        return newRes;
      }
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException exception) {
      throw ExceptionTransformer.transform(exception);
    }
  }

  protected IResource internalCreateResource(
    String name,
    IPosition position,
    IPropertyMap properties,
    IContent content,
    boolean ignorePropertyFailures)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    RMAdapter.checkAndCreateAccessContext(this.getContext());
    try {
      INamespaceManager nsm = this.getNamespaceManager2(true);
      if (!(nsm instanceof IMutableNamespaceManager)) {
        throw new NotSupportedException();
      }
      else {
        ResourceCreateDescriptor desc =
          new ResourceCreateDescriptor(
            new com.sap.netweaver.bc.rf.common.namespace.DestinationDescriptor(
              this.getHandle().getRid(),
              name,
              OrderPositionTransformer.transform(position),
              false),
            new ContentAndPropertiesDescriptor(
              ContentTransformer.transform(content),
              PropertyTransformer.transformToList(properties),
              ignorePropertyFailures));

        IResourceHandle newHandle = ((IMutableNamespaceManager)nsm).createResource(desc);
        ResourceImpl2 newRes = new ResourceImpl2(newHandle, this.rmAdapter.getNewAbstract(), this.getContext());
        return newRes;
      }
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException exception) {
      throw ExceptionTransformer.transform(exception);
    }
  }

  protected ILockInfo internalCreateResource(String name, ILockProperties lockProperties)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    RMAdapter.checkAndCreateAccessContext(this.getContext());
    try {
      INamespaceManager nsm = this.getNamespaceManager2(true);
      if (!(nsm instanceof IMutableNamespaceManager)) {
        throw new NotSupportedException();
      }
      else {
        ResourceCreateDescriptor desc =
          new ResourceCreateDescriptor(
            new com.sap.netweaver.bc.rf.common.namespace.DestinationDescriptor(
              this.getHandle().getRid(),
              name,
              null,
              false),
            new ContentAndPropertiesDescriptor(null, null, false));
        desc.setLockDescriptor(LockDescriptorTransformer.transform(lockProperties));
        ((IMutableNamespaceManager)nsm).createResource(desc);
        return LockInfoTransformer.transform(desc.getLockInfo());
      }
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException exception) {
      throw ExceptionTransformer.transform(exception);
    }
  }

  protected IResource internalCreateLink(
    String name,
    URL targetURL,
    LinkType linkType,
    IPosition position,
    IPropertyMap properties,
    boolean ignorePropertyFailures)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    RMAdapter.checkAndCreateAccessContext(this.getContext());
    try {
      INamespaceManager nsm = this.getNamespaceManager2(true);
      if (!(nsm instanceof IMutableNamespaceManager)) {
        throw new NotSupportedException();
      }
      else {
        LinkCreateDescriptor desc = null;
        if (linkType.equals(LinkType.INTERNAL)) {
          desc =
            new LinkCreateDescriptor(
              new com.sap.netweaver.bc.rf.common.namespace.DestinationDescriptor(
                this.getHandle().getRid(),
                name,
                OrderPositionTransformer.transform(position),
                false),
              new ContentAndPropertiesDescriptor(
                null,
                PropertyTransformer.transformToList(properties),
                ignorePropertyFailures),
              new com.sap.netweaver.bc.rf.common.namespace.LinkDescriptor(
                com.sap.netweaver.bc.rf.common.namespace.LinkType.INTERNAL_STATIC,
                new Rid(targetURL.toString())));
        }
        else {
          desc =
            new LinkCreateDescriptor(
              new com.sap.netweaver.bc.rf.common.namespace.DestinationDescriptor(
                this.getHandle().getRid(),
                name,
                OrderPositionTransformer.transform(position),
                false),
              new ContentAndPropertiesDescriptor(
                null,
                PropertyTransformer.transformToList(properties),
                ignorePropertyFailures),
              new com.sap.netweaver.bc.rf.common.namespace.LinkDescriptor(
                com.sap.netweaver.bc.rf.common.namespace.LinkType.EXTERNAL_STATIC,
                com.sap.netweaver.bc.rf.common.UriFactory.parseUri(targetURL.toString())));
        }
        IResourceHandle newHandle = ((IMutableNamespaceManager)nsm).createResource(desc);
        ResourceImpl2 newRes = new ResourceImpl2(newHandle, this.rmAdapter.getNewAbstract(), this.getContext());
        return newRes;
      }
    }
    catch (MalformedURLException ex) {
      throw new ResourceException(ex.getMessage());
    }
    catch (com.sap.netweaver.bc.rf.common.exception.ResourceException exception) {
      throw ExceptionTransformer.transform(exception);
    }
  }

  protected boolean internalIsCheckedOut() throws ResourceException {
    return GeneralImpl2.internalIsCheckedOut(this);
  }

  protected ICheckOutInfo internalCheckOut() throws ResourceException, NotSupportedException, AccessDeniedException {
    return GeneralImpl2.internalCheckOut(this);
  }

  protected void internalUndoCheckOut() throws ResourceException, NotSupportedException, AccessDeniedException {
    GeneralImpl2.internalUndoCheckOut(this);
  }

  protected ICheckInInfo internalCheckIn(
    IContent newContent,
    IPropertyMap properties,
    boolean ignorePropertyFailures,
    RID expectedCheckInRID)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    return GeneralImpl2.internalCheckIn(this, newContent, properties, ignorePropertyFailures, expectedCheckInRID);
  }

  protected IVersionHistory internalGetVersionHistory() throws ResourceException, NotSupportedException {
    return GeneralImpl2.internalGetVersionHistory(this);
  }

  protected IResourceList internalGetCheckedOutResources()
    throws ResourceException, NotSupportedException, AccessDeniedException {
    return GeneralImpl2.internalGetCheckedOutResources(this);
  }

  protected void internalEnableVersioning(boolean enable)
    throws ResourceException, NotSupportedException, AccessDeniedException {
    RMAdapter.checkAndCreateAccessContext(this.getContext());
  }

  protected boolean internalIsVersioned() throws ResourceException {
    return GeneralImpl2.internalIsVersioned(this);
  }

  // ----------------------------------------------------------------------------
  // Overwrite other public methods in ResourceImpl for access context handling
  // which will or might result in a call to the repository manager.
  // ----------------------------------------------------------------------------

  public ISupportedOptionSet getSupportedOptions() {
    RMAdapter.checkAndCreateAccessContext(this.getContext());
    return super.getSupportedOptions();
  }

  public IRepositoryManager getRepositoryManager() {
    RMAdapter.checkAndCreateAccessContext(this.getContext());
    return super.getRepositoryManager();
  }
}
