/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * Holds status information returned upon a successfull check-out. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author martin.boettcher@greenbytes.de
 * @version $Id: CheckOutInfo2.java,v 1.1 2002/07/30 10:53:55 mbo Exp $
 */
public class CheckOutInfo2 extends CheckOutInfo implements ICheckOutInfo2 {

  private final RID workingResourceRid;

  /**
   * Creates a new instance
   *
   * @param expectedRevisionRID The expected revision RID when the resource
   *      wiull be checked in.
   * @param expectedRevisionID The expected revision ID when the resource wiull
   *      be checked in.
   * @param workingResourceRid The RID of created working resource (or <code>
   *      null</code> when no working resource was created).
   */
  public CheckOutInfo2(RID expectedRevisionRID, String expectedRevisionID, RID workingResourceRid) {
    super(expectedRevisionRID, expectedRevisionID);
    this.workingResourceRid = workingResourceRid;
  }

  public RID getWorkingResourceRID()
    throws ResourceException {
    return this.workingResourceRid;
  }
}
