/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.util.uri.RID;

/**
 * Holds status information returned upon a successfull check-out. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Id:$
 */
public class CheckOutInfo implements ICheckOutInfo {

  private RID revisionRID;
  private String revisionID;

  /**
   * Creates a new instance
   *
   * @param expectedRevisionRID The expected revision RID when the resource
   *      will be checked in.
   * @param expectedRevisionID The expected revision ID when the resource will
   *      be checked in.
   */
  public CheckOutInfo(RID expectedRevisionRID, String expectedRevisionID) {
    this.revisionRID = expectedRevisionRID;
    this.revisionID = expectedRevisionID;
  }

  public RID getExpectedRevisionRID() {
    return this.revisionRID;
  }

  public String getExpectedRevisionID() {
    return this.revisionID;
  }
}
