/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.*;
import com.sapportals.wcm.util.uri.RID;
import com.sapportals.wcm.util.uri.URI;

/**
 * Holds status information returned upon a successfull check-in. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author martin.boettcher@greenbytes.de
 * @version $Id: CheckInInfo2.java,v 1.1 2002/07/30 10:53:55 mbo Exp $
 */
public class CheckInInfo2 extends CheckInInfo implements ICheckInInfo2 {

  private final ICheckOutInfo checkOut;

  public CheckInInfo2(RID revisionRID, String revisionID, ICheckOutInfo checkOut) {
    super(revisionRID, revisionID);
    this.checkOut = checkOut;
  }

  public ICheckOutInfo getCheckOutInfo()
    throws ResourceException {
    return this.checkOut;
  }
}
