/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.WcmObject;
import com.sapportals.wcm.util.uri.RID;
import com.sapportals.wcm.util.uri.URI;

/**
 * Holds status information returned upon a successfull check-in. <p>
 * 
 *
 * Copyright (c) SAP AG 2001-2003
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: CheckInInfo.java,v 1.10 2003/02/17 14:24:03 jre Exp $
 */
public class CheckInInfo extends WcmObject implements ICheckInInfo {

  private RID revisionRID;
  private String revisionID;

  /**
   * @param revisionURI TBD: Description of the incoming method parameter
   * @param revisionID TBD: Description of the incoming method parameter
   * @deprecated as of NW04. Class {@link URI} is deprecated. Use alternative constructor 
   * {@link #CheckInInfo(RID, String)} instead.
   */
  public CheckInInfo(URI revisionURI, String revisionID) {
    this.revisionRID = RID.getRID(revisionURI.toExternalForm(), null);
    this.revisionID = revisionID;
  }

  public URI getRevisionURI() {
    return new URI(this.revisionRID.toString());
  }

  public CheckInInfo(RID revisionRID, String revisionID) {
    this.revisionRID = revisionRID;
    this.revisionID = revisionID;
  }

  public RID getRevisionRID() {
    return this.revisionRID;
  }


  public String getRevisionID() {
    return this.revisionID;
  }
}
