/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.repository.manager.IExtendedNamespaceManager;
import com.sapportals.wcm.util.uri.IRidSet;
import com.sapportals.wcm.util.uri.IUri;

/**
 * Internal link resource object impl. <p>
 *
 * Copyright (c) SAP AG 2002-2003
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: BindableResourceImpl.java,v 1.2 2003/02/17 14:24:03 jre Exp $
 */

public class BindableResourceImpl implements IBindableResource {

  private final IResource resource;
  private final IExtendedNamespaceManager nsmgr;

  public BindableResourceImpl(IResource resource, IExtendedNamespaceManager nsmgr)
    throws ResourceException {
    this.resource = resource;
    this.nsmgr = nsmgr;
  }

  public IRidSet getBindings()
    throws ResourceException {
    return this.nsmgr.getBindings(this.resource);
  }

  public IUri getGloballyUniqueId()
    throws ResourceException {
    return this.nsmgr.getGloballyUniqueId(this.resource);
  }

  public boolean supportsAdditionalBinds()
    throws ResourceException {
    return this.nsmgr.supportsAdditionalBinds(this.resource);
  }

}
