/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.repository;

import com.sapportals.wcm.IFrameworkTransaction;
import com.sapportals.wcm.repository.manager.IExtendedNamespaceManager;
import com.sapportals.wcm.util.uri.RID;

/**
 * Internal bind controller resource implementation <p>
 *
 * Copyright (c) SAP AG 2002-2003
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: BindControllerImpl.java,v 1.3 2003/02/17 14:24:03 jre Exp $
 */

public class BindControllerImpl implements IBindController {

  private final ICollection collection;
  private final IExtendedNamespaceManager nsmgr;

  public BindControllerImpl(ICollection collection, IExtendedNamespaceManager nsmgr)
    throws ResourceException {
    this.collection = collection;
    this.nsmgr = nsmgr;
  }

  public boolean createBind(String memberName, IPosition position, RID targetRid, boolean overwrite)
    throws ResourceException {
    IFrameworkTransaction ft = FrameworkTransaction.required();
    try {
      boolean result = this.nsmgr.createBind(memberName, position, targetRid, overwrite, this.collection);
      ft.commit();
      ft = null;
      return result;
    }
    finally {
      if (ft != null) ft.rollback();
    }
  }

  public boolean createBind(String memberName, IPosition position, IResource targetResource, boolean overwrite)
    throws ResourceException {
    IFrameworkTransaction ft = FrameworkTransaction.required();
    try {
      boolean result = this.nsmgr.createBind(memberName, position, targetResource, overwrite, this.collection);
      ft.commit();
      ft = null;
      return result;
    }
    finally {
      if (ft != null) ft.rollback();
    }
  }
}
