/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.global.service/dev/src/_relation/java/api/com/sapportals/wcm/service/relation/RelationServiceFactory.java#3 $
 */

package com.sapportals.wcm.service.taskqueue;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.service.ServiceFactory;

/**
 * The task queue service factory.
 */
public final class TaskQueueServiceFactory {

  static String TASKQEUE_SERVICE = "TaskQueueService";
  static String version = "$Id: $";

  private TaskQueueServiceFactory() {
  }

  /**
   * Get an instance of the task queue service.
   *
   * @return a <code>ITaskQueueService</code> -instance.
   * @throws WcmException if there was an internal error
   *      while getting the instance of the <code>ISchedulerService</code> .
   */
  public static ITaskQueueService lookup() throws WcmException {
    return (ITaskQueueService)ServiceFactory.getInstance().getService(TASKQEUE_SERVICE);
  }
  
  public static void release(ITaskQueueService service) throws WcmException {
    ServiceFactory.getInstance().releaseService(service);
  }

}