/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.sf.service/60NW_SP_COR/src/_taskqueue/java/api/com/sapportals/wcm/service/taskqueue/TaskQueueException.java#2 $
 */

package com.sapportals.wcm.service.taskqueue;

import com.sapportals.wcm.WcmException;

/**
 * An exception wrapper for the task queue service. All exceptions raised during
 * the task queue service's operations are wrapped in an TaskQueueException. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author Jens Kaiser
 * @version $Revision: #2 $
 */
public class TaskQueueException extends WcmException {

  /**
   * Constructor for the TaskStateChangeException object
   *
   * @param message A short message
   */
  public TaskQueueException(String message) {
    super(message, false);
  }


  /**
   * Constructor for the TaskQueueException object
   *
   * @param x Underlying exception
   */
  public TaskQueueException(Exception x) {
    super(x, false);
  }
  
  /**  
   * Constructor for the TaskQueueException object
   *
   * @param message A short message
   * @param x Underlying exception
   */
  public TaskQueueException(String message, Exception x) {
    super(message, x, false);
  }

}
