/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.sf.service/60NW_SP_COR/src/_taskqueue/java/api/com/sapportals/wcm/service/taskqueue/ITaskQueueIterator.java#2 $
 */

package com.sapportals.wcm.service.taskqueue;

/**
 * An iterator for task queues.<p>
 *
 * This iterator is similar to the {@link java.util.ListIterator ListIterator}
 * interface. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author Jens Kaiser
 * @version $Revision: #2 $
 */
public interface ITaskQueueIterator {

  /**
   * Indicates if another entry exists
   *
   * @return Another entry exists
   */
  boolean hasNext();


  /**
   * Returns the next entry.
   *
   * @return the next entry.
   */
  ITask next();
}
