/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.sf.service/60NW_SP_COR/src/_taskqueue/java/api/com/sapportals/wcm/service/taskqueue/ITask.java#2 $
 */

package com.sapportals.wcm.service.taskqueue;

import java.util.Date;
import java.util.Properties;

/**
 * Entry of a task queue. This interface discribes a task to be executed by an
 * application or service. <p>
 *
 * A task has the following properties:
 * <tableborder="1"CELLSPACING="0"CELLPADDING="3">
 *
 *   <tr>
 *
 *     <td>
 *       <em>Name</em>
 *     </td>
 *
 *     <td>
 *       <em>Required</em>
 *     </td>
 *
 *   </tr>
 *
 *   <tr>
 *
 *     <td>
 *       ID
 *     </td>
 *
 *     <td>
 *       Yes
 *     </td>
 *
 *   </tr>
 *
 *   <tr>
 *
 *     <td>
 *       Namespace
 *     </td>
 *
 *     <td>
 *       Yes
 *     </td>
 *
 *   </tr>
 *
 *   <tr>
 *
 *     <td>
 *       CreatedBy
 *     </td>
 *
 *     <td>
 *       Yes
 *     </td>
 *
 *   </tr>
 *
 *   <tr>
 *
 *     <td>
 *       CreationDate
 *     </td>
 *
 *     <td>
 *       Yes
 *     </td>
 *
 *   </tr>
 *
 *   <tr>
 *
 *     <td>
 *       State
 *     </td>
 *
 *     <td>
 *       Yes
 *     </td>
 *
 *   </tr>
 *
 *   <tr>
 *
 *     <td>
 *       LastModified
 *     </td>
 *
 *     <td>
 *       Yes
 *     </td>
 *
 *   </tr>
 *
 *   <tr>
 *
 *     <td>
 *       Priority
 *     </td>
 *
 *     <td>
 *       Yes
 *     </td>
 *
 *   </tr>
 *
 *   <tr>
 *
 *     <td>
 *       Value by name
 *     </td>
 *
 *     <td>
 *       No
 *     </td>
 *
 *   </tr>
 *
 *   <tr>
 *
 *     <td>
 *       Description
 *     </td>
 *
 *     <td>
 *       No
 *     </td>
 *
 *   </tr>
 *
 * </table>
 * <p>
 *
 * A task object is created by the {@link ITaskQueueWriter writer} factory
 * methods. This methods provide validation of the properties settings. <p>
 *
 * <!--COPYRIGHT TAG:-->Copyright 2004 SAP AG<!-- -->
 *
 * @author Jens Kaiser
 * @version $Revision: #2 $
 */
public interface ITask {

  /**
   * Default value to set the task priority to a minimum (0).
   */
  int MIN_PRIORITY = 0;

  /**
   * Default task priority (50).
   */
  int NORM_PRIORITY = 50;

  /**
   * Default value to set the task priority to a maximum (100).
   */
  int MAX_PRIORITY = 100;


  /**
   * The tasks unique id will be created by the underlying persistence layer.
   *
   * @return The tasks unique id.
   */
  String getID();


  /**
   * Returns the namespace this entry is assigned to.
   *
   * @return The namespace
   */
  String getNamespace();


  /**
   * Returns the user who created this entry.
   *
   * @return The createdBy value
   */
  String getCreatedBy();


  /**
   * Returns the date this entry was created.
   *
   * @return The creationDate value
   */
  Date getCreationDate();


  /**
   * The current state of this task.
   *
   * @return The current state
   */
  TaskState getState();


  /**
   * The last time the task state was changed.
   *
   * @return The last time the task state was changed.
   */
  Date getLastModified();


  /**
   * Gets the priority of this task. Since the task queue service provides a
   * priority queue, the returned value affects the FIFO order of the {@link
   * ITaskQueue queue}. Default settings are {@link #MIN_PRIORITY MIN_PRIORITY},
   * {@link #NORM_PRIORITY NORM_PRIORITY} and {@link #MAX_PRIORITY
   * MAX_PRIORITY}.
   *
   * @return The priority of this task.
   */
  int getPriority();


  /**
   * Returns the property value for the specified key.
   *
   * @param name a unique name
   * @return The property value
   */
  String getValue(String name);


  /**
   * Returns the complete property bundle of this task queue
   *
   * @return properties
   */
  Properties getProperties();


  /**
   * Returns a short description
   *
   * @return The description string
   */
  String getDescription();

}
