package com.sap.caf.core.utils;

import java.util.Map;
import java.util.HashMap;
import java.util.Collections;

import javax.ejb.EJBLocalHome;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import com.sap.caf.rt.exception.ServiceException;

public class HomeFactory {

	private InitialContext context;
	private Map cache;
	private static HomeFactory factory;

	static {
		try {
			factory = new HomeFactory();
		} catch(ServiceException se) {
			//$JL-EXC$
			se.printStackTrace(System.err);
		}
	}

	private HomeFactory() throws ServiceException  {
		try {
			context = new InitialContext();
			cache = Collections.synchronizedMap(new HashMap());
		} catch (NamingException ne) {
			throw new ServiceException(ne);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
	}

	static public HomeFactory getInstance() {
		return factory;
	}
    
	public EJBLocalHome getLocalHome(String jndiHomeName) throws ServiceException {
		EJBLocalHome home = null;
		try { 
			if (cache.containsKey(jndiHomeName)) {
				home = (EJBLocalHome) cache.get(jndiHomeName);
			} else {         
				home = (EJBLocalHome) context.lookup(jndiHomeName);
				cache.put(jndiHomeName, home);
			}
		} catch (NamingException ne) {
			throw new ServiceException(ne);
		} catch (Exception e) {
			throw new ServiceException(e);
		}
		return home;
	}	
}