package com.sap.caf.core.extsrv; 


import java.util.*;
import javax.naming.InitialContext;

import com.sap.caf.mp.core.ICoreFactory;
import com.sap.caf.mp.core.data.mapping.api.IMappingService;
import com.sap.caf.mp.core.data.persistence.api.IServiceDescriptionPersistence;
import com.sap.caf.mp.core.data.service.IDataServiceFactory;
import com.sap.caf.mp.core.data.service.interfce.api.IOperation;
import com.sap.caf.mp.core.data.service.interfce.api.IPorttype;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinition;
import com.sap.caf.mp.core.data.service.registry.IServicesRegistry;
import com.sap.caf.mp.core.data.values.api.IMessageValue;
import com.sap.caf.rt.bol.da.remote.MessageEntityConverter;

public class MPConnector
{
	private static ICoreFactory coreFactory;
	private static IDataServiceFactory dataServiceFactory;
	private static IServicesRegistry servicesRegistry;
	private static IServiceDescriptionPersistence serviceDescriptionPersistence;
	private static IMappingService mappingService;
	private static boolean initialized = false;

	public static boolean initialize()
	{
		if (!initialized)
		{
			try
			{
				InitialContext context = new InitialContext();
				coreFactory = (ICoreFactory) context.lookup(ICoreFactory.JNDI_REGISTRY_NAME);
				dataServiceFactory = coreFactory.getDataServiceFactory();
				servicesRegistry = dataServiceFactory.getServicesRegistry();
				serviceDescriptionPersistence = dataServiceFactory.getServiceDescriptionPersistence();
				mappingService = dataServiceFactory.getMappingService();
				initialized = true;
			} catch (Exception e)
			{
				e.printStackTrace();
			}			
		}
		return initialized;
	}

	public static synchronized void process(
		String serviceId,
		String operationName,
		Object inputParam,
		Object outputParam,
		String mpType,
		Properties credentialProps)
		throws Exception
	{
	    initialize();
		IServiceDefinition sd = servicesRegistry.readServiceDefinition(serviceId);
		IPorttype pt = sd.getPortType();
		IOperation op = pt.getOperation(operationName);

		IMessageValue imv = MessageEntityConverter.getInstance().createInputMessageValue(inputParam, op.getInputOperationpart().getMessage());
		Properties props = null;
		// ADD OPERATION PROPERTIES	
		props = (Properties) sd.getOperationProperties().get(operationName);
		if (props != null)
			credentialProps.putAll(props);
			
		// ADD SD PROPERTIES	
		props = sd.getPortTypeProperties();
		if (props != null)
			credentialProps.putAll(props);

		com.sap.caf.mp.core.data.service.IServiceResponse sr =
			dataServiceFactory.executeOperation(
				mpType,
				imv,
				op,
				credentialProps,
				null);

		MessageEntityConverter.getInstance().retrieveMessageValue(sr.getResponseMessage(), outputParam);
	}

}
