/*
 * Created on 12.08.2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.caf.core.besrv.topic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.naming.Context;

import com.sap.caf.core.CoreServices;
import com.sap.caf.km.ejb.svc.kmcoll.TopicHeader;
import com.sap.caf.km.ejb.svc.kmcoll.bean.CollaborationLocal;
import com.sap.caf.km.ejb.svc.kmcoll.bean.CollaborationLocalHome;
import com.sap.caf.rt.bol.EntityServiceBase;
import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.CAFDeleteException;
import com.sap.caf.rt.exception.CAFRetrieveException;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @author valery_tadra
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */

/**
 * @ejbLocal <{com.sap.caf.core.besrv.topic.TopicServiceLocal}>
 * @ejbLocalHome <{com.sap.caf.core.besrv.topic.TopicServiceLocalHome}>
 * @stateless 
 */
public class TopicServiceBean extends EntityServiceBase implements SessionBean {

	private static final Location location = Location.getLocation(TopicServiceBean.class);

	public void ejbCreate() throws CreateException {
	}

	public void ejbRemove() {
	}

	public void ejbActivate() {
	}

	public void ejbPassivate() {
	}


	public Topic create(String name, String subject, String text, String discussion, String parentTopicRid) throws CAFCreateException {
		String method = "create(String name, String subject, String text, String discussion, String parentTopicRid)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			Topic.JARM_REQUEST,
			method,
			location,
			new Object[] { name, subject, text, discussion, parentTopicRid });
			
		Topic topic = new Topic();
		topic.setDiscussion(discussion);
		topic.setParentTopicRid(parentTopicRid);
		topic.setName(name);
		topic.setText(text);	
		topic.setSubject(subject);	

		// Set the administrational attributes
		Date changeDate = new Date();
		topic.setCreatedBy(user);
		topic.setCreatedAt(changeDate);
		topic.setLastChangedBy(user);
		topic.setLastChangedAt(changeDate);		
				
		try {
			
			String topicRid = CoreServices.getCollaborationService().createTopic(discussion, parentTopicRid, name, subject, text);
			topic.setKey(topicRid);
			topic.setRid(topicRid);	
			
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(
				user,
				Topic.JARM_REQUEST,
				method,
				location);
			throw new CAFCreateException("BO_CREATE", e);
		}

		
		CAFPublicLogger.exiting(
			user,
			Topic.JARM_REQUEST,
			method,
			location,
			new Object[] { topic });
		return topic;		
	}

	public Topic read(String key) throws CAFRetrieveException {
		String method = "read(String)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			Topic.JARM_REQUEST,
			method,
			location,
			new Object[] { key });
	
		Topic topic = null;
		try {
			TopicHeader header = CoreServices.getCollaborationService().findTopic(key);
			if (header != null){
				topic = new Topic(header);
			}				
							
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(
				user,
				Topic.JARM_REQUEST,
				method,
				location);
			throw new CAFRetrieveException("BO_READ", e);
		}

		CAFPublicLogger.exiting(
			user,
			Topic.JARM_REQUEST,
			method,
			location,
			new Object[] { topic });
		return topic;
	}

	public void update(Topic topic) throws CAFUpdateException {
		String method = "update(Topic)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			Topic.JARM_REQUEST,
			method,
			location,
			new Object[] { topic });
			
		// not supported
		
		CAFPublicLogger.exiting(user, Topic.JARM_REQUEST, method, location);	
	}
	
	
	public void delete(Topic topic) throws CAFDeleteException {
		String method = "delete(Topic)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			Topic.JARM_REQUEST,
			method,
			location,
			new Object[] { topic });

		try {
			CoreServices.getCollaborationService().removeTopic(topic.getDiscussion(), topic.getKey());
			
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(
				user,
				Topic.JARM_REQUEST,
				method,
				location);
			throw new CAFDeleteException(e);
		}

		CAFPublicLogger.exiting(user, Topic.JARM_REQUEST, method, location);
	}
	
	public Collection findByDiscussion(String discussionId) throws CAFRetrieveException {
		String method = "findByDiscussion(String)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			Topic.JARM_REQUEST,
			method,
			location,
			new Object[] { discussionId });
	
		ArrayList result = new ArrayList();
		Topic topic = null;
		try {
			
			TopicHeader[] topicHeaders = CoreServices.getCollaborationService().findByDiscussion(discussionId);
			if (topicHeaders != null) {
				for( int index = 0; index < topicHeaders.length; index++) {
					topic = new Topic(topicHeaders[index]);
					result.add(topic);				
				}
			}			
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(
				user,
				Topic.JARM_REQUEST,
				method,
				location);
			throw new CAFRetrieveException("BO_READ", e);
		}

		CAFPublicLogger.exiting(
			user,
			Topic.JARM_REQUEST,
			method,
			location,
			new Object[] { topic });
		return result;
	}

}
