/*
 * Created on 12.08.2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.caf.core.besrv.topic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import com.sap.caf.km.ejb.svc.kmcoll.TopicHeader;
import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.pk.AbstractPrimaryKey;

/**
 * @author valery_tadra
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class Topic implements IBusinessObject, Serializable {


	private transient String createdBy;
	private transient Date createdAt;
	private transient String lastChangedBy;
	private transient Date lastChangedAt;

	private String key;
	private String	name;
	private String	rid;
	private String  subject;
	private int 	postCount;
	private String text;
	private String discussion;
	private String parentTopicRid;
	
	private ArrayList topics = new ArrayList();
	
	private static List propList = new ArrayList();
	
	private static final String APPLICATION	= "com.sap.caf.core.services.Topic";
	public static final String JARM_REQUEST = "XAP:SRV:" + APPLICATION;
	public static final String OBJECT_NAME = "sap.com/caf.core/Topic";
	
		static {
			propList.add("key");
			propList.add("name");
			propList.add("rid");
			propList.add("subject");
			propList.add("postCount");
			propList.add("text");
			propList.add("discussion");
			propList.add("parentTopicRid");
			propList.add("topics");
			propList.add("createdBy");
			propList.add("createdAt");
			propList.add("lastChangedBy");
			propList.add("lastChangedAt");		

		}
		
		public Topic() {
		}

	public Topic(String id) {
		this.key = id;
	}
	
	public Topic(TopicHeader header) {
		this.rid = header.getId();
		this.setKey(header.getId());
		this.name = header.getName();
		this.subject = header.getSubject();
		this.text = header.getText();
		this.discussion = header.getDiscussion();
		this.createdAt = header.getCreatedAt();
		this.createdBy = header.getCreatedBy();
		this.lastChangedAt = header.getLastChangedAt();
		this.lastChangedBy = header.getLastChangedBy();
		this.postCount = header.getSize();
		this.parentTopicRid = header.getParentTopicRid();
		
		if (header.getTopics() != null){
			this.topics = new ArrayList(header.getTopics());
		}
	}
	
	/**
	 * @see IBusinessObject.getObjectType()
	 */
	public String getObjectType() {
		return OBJECT_NAME;
	}
	
	
	public java.lang.String getKey() {
		return key;
	}

	public void setKey(java.lang.String string) {
		key = string;
	}
	
	public java.lang.String getName() {
		return name;
	}

	public void setName(java.lang.String string) {
		name = string;
	}

	
	public java.lang.String getSubject() {
		return subject;
	}

	public void setSubject(java.lang.String string) {
		subject = string;
	}
	
	public int getPostCount() {
		return postCount;
	}

	public void setPostCount(int value) {
		postCount = value;
	}

	public void addTopic(java.lang.String topic) {
		this.topics.add( topic );
	}
	
	public void removeTopic(java.lang.String topic) {
		this.topics.remove( topic );
	}
	
	public void setTopics(Collection topics) {
		topics = new ArrayList(topics);
	}	
	
	public java.util.ArrayList getTopics() {
		return new ArrayList(topics);
	}

	/**
	 * @return
	 */
	public String getText() {
		return text;
	}


	/**
	 * @param string
	 */
	public void setText(String string) {
		text = string;
	}

	/**
	 * @return
	 */
	public String getDiscussion() {
		return discussion;
	}

	/**
	 * @param string
	 */
	public void setDiscussion(String string) {
		discussion = string;
	}

	/**
	 * @return
	 */
	public String getRid() {
		return rid;
	}

	/**
	 * @return
	 */
	public String getParentTopicRid() {
		return parentTopicRid;
	}

	/**
	 * @param string
	 */
	public void setRid(String string) {
		rid = string;
	}

	/**
	 * @param string
	 */
	public void setParentTopicRid(String string) {
		parentTopicRid = string;
	}
	
	
	public java.lang.String getCreatedBy() {
		return createdBy;
	}
	
	public void setCreatedBy(java.lang.String createdBy) {
		this.createdBy = createdBy;
	}

	public java.util.Date getCreatedAt() {
		return createdAt;
	}
	
	public void setCreatedAt(java.util.Date createdAt) {
		this.createdAt = createdAt;
	}

	public java.lang.String getLastChangedBy() {
		return lastChangedBy;
	}
	public void setLastChangedBy(java.lang.String lastChangedBy) {
		this.lastChangedBy = lastChangedBy;
	}

	public java.util.Date getLastChangedAt() {
		return lastChangedAt;
	}
	
	public void setLastChangedAt(java.util.Date lastChangedAt) {
		this.lastChangedAt = lastChangedAt;
	}


	public boolean validate() {
		return true;
	}
	/* (non-Javadoc)
	 * @see com.sap.caf.rt.bol.IDependentObject#getPK()
	 */
	public AbstractPrimaryKey getPK() {
		return new TopicPK(getKey());
	}
	
	public List getPropertyList() {	
		return propList;
	}
	
	public Object getProperty(String propertyName) {
		String method = "getProperty()";
		//BOPublicLogger.entering(null, jARMRequest, method, APPLICATION);

		Object prop = null;
		if (propertyName.equals("key")) { prop =  this.getKey();}
		else if (propertyName.equals("name")) { prop = this.getName();}
		else if (propertyName.equals("rid")) { prop = this.getRid();}
		else if (propertyName.equals("subject")) { prop = this.getSubject();}
		else if (propertyName.equals("postCount")) { prop = new Integer(this.getPostCount());}
		else if (propertyName.equals("topics")) { prop = this.getTopics();}
		else if (propertyName.equals("parentTopicRid")) { prop = this.getParentTopicRid();}
		else if (propertyName.equals("text")) { prop = this.getText();}
		else if (propertyName.equals("discussion")) { prop = this.getDiscussion();}
		else if (propertyName.equals("createdBy")) { prop = this.getCreatedBy();}
		else if (propertyName.equals("createdAt")) { prop = this.getCreatedAt();}
		else if (propertyName.equals("lastChangedBy")) { prop = this.getLastChangedBy();}
		else if (propertyName.equals("lastChangedAt")) { prop = this.getLastChangedAt();}
		
		//BOPublicLogger.exiting(null, jARMRequest, method, APPLICATION);
		
		return prop;
	}

	public void setProperty(String propertyName, Object propertyValue) {
		String method = "setProperty()";
		//BOPublicLogger.entering(null, jARMRequest, method, APPLICATION);

		if (propertyName.equals("createdBy")) { this.setCreatedBy((String)propertyValue);}
		else if (propertyName.equals("createdAt")) { this.setCreatedAt((Date)propertyValue);}
		else if (propertyName.equals("lastChangedBy")) { this.setLastChangedBy((String)propertyValue);}
		else if (propertyName.equals("lastChangedAt")) { this.setLastChangedAt((Date)propertyValue);}
		else if (propertyName.equals("key")) { this.setKey((String)propertyValue);}
		else if (propertyName.equals("rid")) { this.setRid((String)propertyValue);}
		else if (propertyName.equals("name")) { this.setName((java.lang.String)propertyValue);}
		else if (propertyName.equals("subject")) { this.setSubject((java.lang.String)propertyValue);}
		else if (propertyName.equals("postCount")) { this.setPostCount(((java.lang.Integer)propertyValue).intValue());}
		else if (propertyName.equals("discussion")) { this.setDiscussion((java.lang.String)propertyValue);}
		else if (propertyName.equals("text")) { this.setText((java.lang.String)propertyValue);}
		else if (propertyName.equals("parentTopicRid")) { this.setParentTopicRid((java.lang.String)propertyValue);}
		
		else if (propertyName.equals("topics")) { setTopics((Collection)propertyValue);}		
	}

}
