package com.sap.caf.core.besrv.principal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.pk.AbstractPrimaryKey;

public class Principal implements IDependentObject, Serializable { 

        private String principalID;
        private String principalName;
        private String principalType;
        private String description;
        private String email;
        
        private static List propList = new ArrayList();
        
        public static final String PROVIDER = "sap.com";
        public static final String APPLICATION = "caf.core";
        public static final String BE_SRV_NAME = "Principal";
        public static final String JARM_REQUEST = "XAP:BO:" + PROVIDER + "/" + APPLICATION + "/" + BE_SRV_NAME;
        
        static {
				propList.add("key");
                propList.add("principalID");
                propList.add("principalName");
                propList.add("principalType");
                propList.add("description");
                propList.add("email");
        }
        
        public Principal() {
        }

        public List getPropertyList() {                         
                return propList;
        }

        public boolean validate() {
                return true;
        }

        public String getObjectType() {
                return PROVIDER + "/" + APPLICATION + "/" + BE_SRV_NAME;        
        }

        // *** GET/SET Methods ***
        public AbstractPrimaryKey getPK() {
        //              return new ObjectPK(getKey());
                return null;
        }

        public Object getProperty(String propertyName) {
                Object prop = null; 
                if 		("principalID".equals(propertyName)) 	{ prop =  getPrincipalID(); } 
                else if ("principalName".equals(propertyName))  { prop =  getPrincipalName(); }
                else if ("principalType".equals(propertyName))  { prop =  getPrincipalType(); }
                else if ("description".equals(propertyName))    { prop =  getDescription(); }
                else if ("email".equals(propertyName))  		{ prop =  getEmail(); }
                else if ("key".equals(propertyName))  			{ prop =  getKey(); }
                return prop;
        }

        public void setProperty(String propertyName, Object propertyValue) {
                String value = (String)propertyValue;
                if      ("principalID".equals(propertyName))    { setPrincipalID(value); }
                else if ("principalName".equals(propertyName))  { setPrincipalName(value); }
                else if ("principalType".equals(propertyName))  { setPrincipalType(value); }
                else if ("description".equals(propertyName))    { setDescription(value); }
        		else if ("email".equals(propertyName))  		{ setEmail(value); }
				else if ("key".equals(propertyName))  			{ setKey(value); }
        }

        /**
         * @return
         */
        public String getPrincipalName() {
                return principalName;
        }

        /**
         * @param string
         */
        public void setPrincipalName(String string) {
                principalName = string;
        }
        

        /**
         * @return
         */
        public String getDescription() {
                return description;
        }

        /**
         * @return
         */
        public String getKey() {
                return principalID;
        }

        /**
         * @return
         */
        public String getPrincipalType() {
                return principalType;
        }

        /**
         * @param string
         */
        public void setDescription(String string) {
                description = string;
        }

        /**
         * @param string
         */
        void setKey(String string) {
                principalID = string;
        }

        /**
         * @param string
         */
        public void setPrincipalType(String string) {
                principalType = string;
        }

		/**
		 * @return
		 */
		public String getEmail()
		{
			return email;
		}

		/**
		 * @return
		 */
		public String getPrincipalID()
		{
			return principalID;
		}

		/**
		 * @param string
		 */
		public void setEmail(String string)
		{
			email = string;
		}

		/**
		 * @param string
		 */
		public void setPrincipalID(String string)
		{
			principalID = string;
		}

}