package com.sap.caf.core.besrv.exchangerate;

import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.CreateException;

import java.util.*;

import com.sap.caf.rt.bol.EntityServiceBase;
import com.sap.caf.rt.exception.CAFFindException;
import com.sap.caf.rt.bol.util.IntQueryFilter;
import com.sap.caf.rt.bol.util.QueryFilter;
import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.bol.da.DataAccessFactory;
import com.sap.caf.rt.bol.da.IDataAccessService;
import com.sap.caf.rt.bol.pk.PrimaryKeyFactory;
import com.sap.caf.rt.exception.BEException;
import com.sap.caf.rt.exception.CAFBaseException;
import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.CAFDeleteException;
import com.sap.caf.rt.exception.CAFRetrieveException;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.security.util.CAFPermissionName;
import com.sap.caf.rt.security.acl.impl.CAFPermission;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.caf.rt.metamodel.MetaModel;
import com.sap.caf.rt.services.notify.notif.NotifException;
import com.sap.caf.rt.services.notify.notif.bobject.BOChangedEvent;
import com.sap.caf.rt.services.notify.notif.bobject.BOChangedPublisher;
import com.sap.caf.rt.services.notify.notif.bobject.IBOChangedEvent;
import com.sap.caf.rt.services.notify.subscr.bobject.BOSubscrType;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;


/**
 * @ejbHome <{com.sap.caf.core.besrv.exchangerate.ExchangeRateServiceHome}>
 * @ejbLocal <{com.sap.caf.core.besrv.exchangerate.ExchangeRateServiceLocal}>
 * @ejbLocalHome <{com.sap.caf.core.besrv.exchangerate.ExchangeRateServiceLocalHome}>
 * @ejbRemote <{com.sap.caf.core.besrv.exchangerate.ExchangeRateService}>
 * @stateless 
 * @transactionType Container
 */
public class ExchangeRateServiceBean extends EntityServiceBase implements SessionBean { //$JL-SER$

    private IDataAccessService dataAccessService;    
    private static final Location LOCATION = Location.getLocation(ExchangeRateServiceBean.class);    
    
    public void ejbRemove() {
        java.lang.String method = ExchangeRate.JARM_REQUEST + ":ejbRemove()";
        CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
        dataAccessService.destroy();
        CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
    }

    public void ejbCreate() throws CreateException {
      _objectName = "sap.com/caf.core/ExchangeRate";
        java.lang.String method = "ejbCreate()";
        CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
        try {
            dataAccessService = DataAccessFactory.getDataAccessService(DataAccessFactory.DATASOURCE_REMOTE);
            dataAccessService.activate();
        } catch (Exception e) {
            CAFPublicLogger.traceThrowableT(Severity.DEBUG, ExchangeRateServiceBean.LOCATION, method, "Error in ejbCreate()", e);
            throw new CreateException(); // $JL-EXC$
        } finally {
            CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
        }
    }

    public ExchangeRate create() throws CAFCreateException {
        java.lang.String method = ExchangeRate.JARM_REQUEST + ":create()";
        java.lang.String user = sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, new Object[] {}, CAFPublicLogger.LEVEL_MEDIUM);


        ExchangeRate be = new ExchangeRate();
        
        ExchangeRatePK primaryKey;
        try {
        IBOChangedEvent event = new BOChangedEvent(be, BOSubscrType.CREATED);
        be.setNotifEvent(event);
        
          // Set the administrational attributes
          Date time = new Date();
          be.setCreatedBy(user);
          be.setCreatedAt(time);
          be.setLastChangedBy(user);
          be.setLastChangedAt(time);
        
            primaryKey = new ExchangeRatePK(PrimaryKeyFactory.getInstance().getPrimaryKey());
            be.setKey(primaryKey.key);
            
            dataAccessService.create(be);
        } catch (CAFBaseException e) {
            ExchangeRateServiceBean.LOCATION.throwing(method, e);
            CAFPublicLogger.exiting(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
            throw new CAFCreateException("BO_CREATE", e);
        } catch (RuntimeException e) {
          throw e;
        } catch (Exception e) {
            CAFPublicLogger.traceThrowableT(Severity.DEBUG, ExchangeRateServiceBean.LOCATION, method, "Error in " + method, e);
            ExchangeRateServiceBean.LOCATION.throwing(method, e);
            CAFPublicLogger.exiting(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
            throw new CAFCreateException("BO_CREATE", e);
        }        

        CAFPublicLogger.exiting(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, new Object[] {be}, CAFPublicLogger.LEVEL_MEDIUM);
        return be;
    }

    public ExchangeRate read(java.lang.String key) throws CAFRetrieveException {
        java.lang.String method = ExchangeRate.JARM_REQUEST + ":read(java.lang.String)";        
    java.lang.String user = sessionContext.getCallerPrincipal().getName();
    CAFPublicLogger.entering(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, new Object[] {key}, CAFPublicLogger.LEVEL_MEDIUM);

    ExchangeRatePK primaryKey = new ExchangeRatePK(key);
    ExchangeRate be;
    try {
      be = (ExchangeRate) dataAccessService.load(primaryKey, ExchangeRate.class);
        IBOChangedEvent event = new BOChangedEvent(be, BOSubscrType.UPDATED);
        be.setNotifEvent(event);
    } catch (DataAccessException e) {
      ExchangeRateServiceBean.LOCATION.throwing(method, e);
      CAFPublicLogger.exiting(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
      throw new CAFRetrieveException("BO_READ", e);
    } catch (RuntimeException e) {
          throw e;
        } catch (Exception e) {
      CAFPublicLogger.traceThrowableT(Severity.DEBUG, ExchangeRateServiceBean.LOCATION, method, "Error in " + method, e);
      ExchangeRateServiceBean.LOCATION.throwing(method, e);
      CAFPublicLogger.exiting(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
      throw new CAFRetrieveException("BO_READ", e);
    }


    CAFPublicLogger.exiting(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, new Object[] {be}, CAFPublicLogger.LEVEL_MEDIUM);
    return be;
    }

    public void update(ExchangeRate be) throws CAFUpdateException {
        java.lang.String method = ExchangeRate.JARM_REQUEST + ":update(ExchangeRate)";
    java.lang.String user = sessionContext.getCallerPrincipal().getName();
    CAFPublicLogger.entering(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, new Object[] {be}, CAFPublicLogger.LEVEL_MEDIUM);


    java.lang.String prevLastChangedBy = be.getLastChangedBy();
    Date prevLastChangedAt = be.getLastChangedAt();
    Date now = new Date();
    ExchangeRate beForUpdate = be;
        // Set the administrational attributes
        be.setLastChangedBy(user);
        be.setLastChangedAt(now);

        try {
            dataAccessService.store(beForUpdate);
            notifyChanged(beForUpdate.getNotifEvent());
        } catch (DataAccessException e) {
          be.setLastChangedBy(prevLastChangedBy);
        be.setLastChangedAt(prevLastChangedAt);
        
            ExchangeRateServiceBean.LOCATION.throwing(method, e);
            CAFPublicLogger.exiting(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
            throw new CAFUpdateException("BO_UPDATE", e);
        } catch (RuntimeException e) {
          throw e;
        } catch (Exception e) {
          be.setLastChangedBy(prevLastChangedBy);
        be.setLastChangedAt(prevLastChangedAt);
        
            CAFPublicLogger.traceThrowableT(Severity.DEBUG, ExchangeRateServiceBean.LOCATION, method, "Error in " + method, e);
            ExchangeRateServiceBean.LOCATION.throwing(method, e);
            CAFPublicLogger.exiting(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
            throw new CAFUpdateException("BO_UPDATE", e);
        }

        CAFPublicLogger.exiting(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
    }

    public void delete(ExchangeRate be) throws CAFDeleteException {
        java.lang.String method = ExchangeRate.JARM_REQUEST + ":delete(ExchangeRate)";
        java.lang.String user = sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, new Object[] {be}, CAFPublicLogger.LEVEL_MEDIUM);


        try {
            IBOChangedEvent event = be.getNotifEvent();
            dataAccessService.remove(be);
            notifyChanged(event);
        } catch (DataAccessException e) {
            ExchangeRateServiceBean.LOCATION.throwing(method, e);
            CAFPublicLogger.exiting(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
            throw new CAFDeleteException("BO_DELETE", e);
        } catch (RuntimeException e) {
          throw e;
        } catch (Exception e) {
            CAFPublicLogger.traceThrowableT(Severity.DEBUG, ExchangeRateServiceBean.LOCATION, method, "Error in " + method, e);
            ExchangeRateServiceBean.LOCATION.throwing(method, e);
            CAFPublicLogger.exiting(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
            throw new CAFDeleteException(e);
        }

        CAFPublicLogger.exiting(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
    }

    public java.util.ArrayList getExchangeRate(QueryFilter currencyFromFilter, QueryFilter currencyToFilter, QueryFilter rateTypeFilter, QueryFilter dateFilter) throws CAFFindException {
        java.lang.String method = ExchangeRate.JARM_REQUEST + ":getExchangeRate(QueryFilter, QueryFilter, QueryFilter, QueryFilter)";
        java.lang.String user = sessionContext.getCallerPrincipal().getName();
        CAFPublicLogger.entering(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
        
        Map queriesMap = new HashMap();   
    queriesMap.put("currencyFrom", currencyFromFilter);
    queriesMap.put("rateType", rateTypeFilter);
    queriesMap.put("date", dateFilter);
    queriesMap.put("currencyTo", currencyToFilter);
    java.util.ArrayList result = findByMultipleParameters(queriesMap, false, "getExchangeRate");
    CAFPublicLogger.exiting(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
    return result;
    }

  public java.util.ArrayList findByMultipleParameters(Map mapNameToFilter, boolean implCheck, java.lang.String findByName) throws CAFFindException {
    java.lang.String method = ExchangeRate.JARM_REQUEST + ":findByMultipleParameters(Map)";
    java.lang.String user = sessionContext.getCallerPrincipal().getName();
    CAFPublicLogger.entering(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, new Object[] {mapNameToFilter}, CAFPublicLogger.LEVEL_MEDIUM);
    
    java.util.ArrayList result = new java.util.ArrayList();
    
    Set inputSet = mapNameToFilter.entrySet();
    Iterator it = inputSet.iterator();
    int nSize = inputSet.size();

    /* for logger */
    Object[] objAttribs = new Object[nSize];
    java.lang.String strInputParams = "input params : ";

    /* for filters */
    java.util.ArrayList resultQueries = new java.util.ArrayList(nSize);

    for (int i = 0; it.hasNext(); i++) {
      Map.Entry entry = (Map.Entry) it.next();
      java.lang.String strParamName = (java.lang.String) entry.getKey();
      Object oValue = entry.getValue();

      resultQueries.addAll(extractQueryFilters(strParamName, oValue));

      /* for logger */
      strInputParams += ((0 != i) ? ", " : "") + strParamName + "={" + i + "}";
      objAttribs[i] = oValue;
    }
    /* for logger */
    CAFPublicLogger.LOC_CAF.debugT(strInputParams, objAttribs);

    try {
      Collection resultSet = dataAccessService.query(ExchangeRate.class, (IntQueryFilter[])resultQueries.toArray(new IntQueryFilter[0]), findByName);
        
      Date time = new Date();     
      Iterator iter = resultSet.iterator();     
      while (iter.hasNext()) {      
        ExchangeRate bo = (ExchangeRate) iter.next();
        
        if (bo.getCreatedBy() == null) {
          bo.setCreatedBy(user);
        }
        if (bo.getCreatedAt() == null) {
          bo.setCreatedAt(time);
        }
        if (bo.getLastChangedBy() == null) {
          bo.setLastChangedBy(user);
        }
        if (bo.getLastChangedAt() == null) {
          bo.setLastChangedAt(time);
        }       
        if ((!implCheck) || checkPermission(CAFPermissionName.read, bo, user, ExchangeRate.OBJECT_NAME)) {
          result.add(bo);
        } 
      }
    } catch (RuntimeException e) {
          throw e;
        } catch (Exception e) {
      ExchangeRateServiceBean.LOCATION.throwing(method, e);
      throw new CAFFindException("BO_FIND", e);
    } finally {
      CAFPublicLogger.exiting(user, ExchangeRate.JARM_REQUEST, method, ExchangeRateServiceBean.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
    }
    return result;
  } 

  protected Collection extractQueryFilters(java.lang.String strParamName, Object oValue) throws CAFFindException {
    Collection resCollection = new ArrayList();
    if (oValue instanceof Collection) {
      int colSize = ((Collection) oValue).size();
      for (Iterator iter = ((Collection) oValue).iterator(); iter.hasNext();) {
        Object value = iter.next();
        Iterator i = extractIntQueryFilter(strParamName, value).iterator();
        while (i.hasNext()) {
          IntQueryFilter qf = (IntQueryFilter)i.next();
          if (colSize > 1) {
            if (resCollection.size() == 0) {
              qf.setInStatementCondition(IntQueryFilter.BOOL_OPERATION_OR_START);
            } else if (!iter.hasNext()) {
              qf.setInStatementCondition(IntQueryFilter.BOOL_OPERATION_OR_END);
            } else {
              qf.setInStatementCondition(IntQueryFilter.BOOL_OPERATION_INNER_OR);
            }
          }
          resCollection.add(qf);
        }
      }
    } else if (oValue instanceof Map) {
      int mapSize = ((Map) oValue).size();
      for (Iterator iter = ((Map) oValue).keySet().iterator(); iter.hasNext();) {
        Map.Entry me = (Map.Entry) iter.next();
        Iterator i = extractIntQueryFilter((java.lang.String) me.getKey(), me.getValue()).iterator();
        while (i.hasNext()) {
          IntQueryFilter qf = (IntQueryFilter)i.next();
          if (mapSize > 1) {
            if (resCollection.size() == 0) {
              qf.setInStatementCondition(IntQueryFilter.BOOL_OPERATION_OR_START);
            } else if (!iter.hasNext()) {
              qf.setInStatementCondition(IntQueryFilter.BOOL_OPERATION_OR_END);
            } else {
              qf.setInStatementCondition(IntQueryFilter.BOOL_OPERATION_INNER_OR);
            }
          }
          resCollection.add(qf);
        }
      }
    } else {
      resCollection.addAll(extractIntQueryFilter(strParamName, oValue));
    }
    return resCollection;
  }
  
    protected Collection extractIntQueryFilter(java.lang.String strParamName, Object oValue) throws CAFFindException {
        IntQueryFilter resQueryFilter = null;
    Collection resCollection = new ArrayList();
        QueryFilter qf = QueryFilter.getQueryFilter(oValue);

        if (qf == null) {
            throw new CAFFindException("filter is not valid");
        } else if (qf instanceof IntQueryFilter) {
      resCollection.add(qf);
        } else if (qf instanceof QueryFilter) {
            int dotIndex = strParamName.indexOf('.');
            java.lang.String attrName = (dotIndex == -1) ? strParamName : strParamName.substring(0, dotIndex);
            java.lang.String subAttrName = (dotIndex == -1) ? null : strParamName.substring(dotIndex + 1, strParamName.length());

       resQueryFilter = new IntQueryFilter((QueryFilter) qf);
      resQueryFilter.setAttribute(strParamName);
      resCollection.add(resQueryFilter);
    }
    return resCollection;
  }


  private boolean checkPermission(java.lang.String permission, IBusinessObject object, java.lang.String user, java.lang.String objectName) {
        boolean allowAccess = true;
        try {
            if (!CAFPermission.checkAclPermission(object, user, permission, objectName)) {
                allowAccess = false;
            }
        } catch (CAFPermissionException e) {
            allowAccess = false;
        }
        return allowAccess;
    }

  private void notifyChanged(IBOChangedEvent notifEvent) throws NotifException {
    if (notifPub==null) {
      if (ExchangeRateServiceBean.LOCATION.beDebug()) {
        ExchangeRateServiceBean.LOCATION.debugT("Could not send a notification: notification publisher is NULL");
      }
      return;
    }
    if (notifEvent==null) {
      if (ExchangeRateServiceBean.LOCATION.beDebug()) {
        ExchangeRateServiceBean.LOCATION.debugT("Could not send a notification: notification event is NULL");
      }
      return; 
    }
    notifPub.notify(notifEvent);
  }
}