package com.sap.caf.core.besrv.exchangerate;

import java.util.*;
import java.io.Serializable;

import javax.jdo.InstanceCallbacks;
import javax.jdo.spi.PersistenceCapable;

import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.bol.pk.AbstractPrimaryKey;
import com.sap.caf.rt.bol.pk.PrimaryKeyFactory;
import com.sap.caf.rt.bol.da.DataAccessFactory;
import com.sap.caf.rt.bol.da.IDataAccessService;
import com.sap.caf.rt.exception.CAFBaseException;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.exception.MissingMandatoryValueException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.caf.rt.services.notify.notif.bobject.IBOChangedEvent;
import com.sap.caf.rt.services.notify.notif.bobject.BOUtils;
import com.sap.caf.rt.services.notify.subscr.bobject.BOSubscrType;

import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;


public class ExchangeRate implements IBusinessObject, Serializable, InstanceCallbacks { //$JL-SER$

	public ExchangeRate() {
	}

	private transient IBOChangedEvent notifEvent;
	private transient boolean notifEnabled = false;	
	private static final Location LOCATION = Location.getLocation(ExchangeRate.class);

  // keys
	private java.lang.String key;
  // attributes (without language dependent and relations)
	private java.util.Date lastChangedAt;
	private java.math.BigDecimal exchangeRate;
	private java.lang.String currencyFrom;
	private java.math.BigDecimal factorTo;
	private java.lang.String lastChangedBy;
	private java.util.Date createdAt;
	private java.lang.String createdBy;
	private java.lang.String rateType;
	private java.lang.String date;
	private java.math.BigDecimal factorFrom;
	private java.lang.String currencyTo;
  // relations

	private static final transient List propList = new ArrayList();
	private static final java.lang.String objectGuid = "B23D82A8-B0CD-3531-4631-B797376F";

	public static final java.lang.String PROVIDER = "sap.com";
	public static final java.lang.String APPLICATION = "caf.core";
	public static final java.lang.String BE_SRV_NAME = "ExchangeRate";
	public static final java.lang.String OBJECT_NAME = PROVIDER + "/" + APPLICATION + "/" + BE_SRV_NAME;
	public static final java.lang.String JARM_REQUEST = "XAP:BO:" + OBJECT_NAME;

	static {
		propList.add("key");
		propList.add("lastChangedAt");
		propList.add("exchangeRate");
		propList.add("currencyFrom");
		propList.add("factorTo");
		propList.add("lastChangedBy");
		propList.add("createdAt");
		propList.add("createdBy");
		propList.add("rateType");
		propList.add("date");
		propList.add("factorFrom");
		propList.add("currencyTo");
	}

	public List getPropertyList() {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getPropertyList()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return propList;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public boolean validate() {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":validate()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return true;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.lang.String getRid() {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getRid()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return CAFContext.KM_REPOSITORY + "/" + objectGuid + "/" + getKey().substring(0, 2) + "/" + getKey().substring(0, 4) + "/r" + getKey();
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.lang.String getObjectType() {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getObjectType()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return OBJECT_NAME;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

// *** GET/SET relations ***
// *** GET/SET keys ***
	public AbstractPrimaryKey getPK() {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getPK()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return new ExchangeRatePK(getKey());
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.lang.String getKey () {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getKey ()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.key;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	protected void setKey (java.lang.String key) {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":setKey (java.lang.String)";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, new Object[] {key}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("key", this.key);
			}
			this.key = key;
			if (notifEnabled) {
				notifEvent.registerNewValue("key", this.key);
			}
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

// *** GET/SET attributes ***
	public java.util.Date getLastChangedAt () {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getLastChangedAt ()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.lastChangedAt;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	protected void setLastChangedAt (java.util.Date lastChangedAt) {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":setLastChangedAt (java.util.Date)";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, new Object[] {this.lastChangedAt}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("lastChangedAt", this.lastChangedAt);
			}
			this.lastChangedAt = lastChangedAt;
			if (notifEnabled) {
				notifEvent.registerNewValue("lastChangedAt", this.lastChangedAt);
			}
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.math.BigDecimal getExchangeRate () {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getExchangeRate ()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.exchangeRate;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void setExchangeRate (java.math.BigDecimal exchangeRate) {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":setExchangeRate (java.math.BigDecimal)";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, new Object[] {this.exchangeRate}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("exchangeRate", this.exchangeRate);
			}
			this.exchangeRate = exchangeRate;
			if (notifEnabled) {
				notifEvent.registerNewValue("exchangeRate", this.exchangeRate);
			}
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.lang.String getCurrencyFrom () {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getCurrencyFrom ()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.currencyFrom;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void setCurrencyFrom (java.lang.String currencyFrom) {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":setCurrencyFrom (java.lang.String)";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, new Object[] {this.currencyFrom}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("currencyFrom", this.currencyFrom);
			}
			this.currencyFrom = currencyFrom;
			if (notifEnabled) {
				notifEvent.registerNewValue("currencyFrom", this.currencyFrom);
			}
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.math.BigDecimal getFactorTo () {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getFactorTo ()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.factorTo;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void setFactorTo (java.math.BigDecimal factorTo) {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":setFactorTo (java.math.BigDecimal)";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, new Object[] {this.factorTo}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("factorTo", this.factorTo);
			}
			this.factorTo = factorTo;
			if (notifEnabled) {
				notifEvent.registerNewValue("factorTo", this.factorTo);
			}
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.lang.String getLastChangedBy () {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getLastChangedBy ()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.lastChangedBy;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	protected void setLastChangedBy (java.lang.String lastChangedBy) {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":setLastChangedBy (java.lang.String)";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, new Object[] {this.lastChangedBy}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("lastChangedBy", this.lastChangedBy);
			}
			this.lastChangedBy = lastChangedBy;
			if (notifEnabled) {
				notifEvent.registerNewValue("lastChangedBy", this.lastChangedBy);
			}
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.util.Date getCreatedAt () {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getCreatedAt ()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.createdAt;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	protected void setCreatedAt (java.util.Date createdAt) {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":setCreatedAt (java.util.Date)";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, new Object[] {this.createdAt}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("createdAt", this.createdAt);
			}
			this.createdAt = createdAt;
			if (notifEnabled) {
				notifEvent.registerNewValue("createdAt", this.createdAt);
			}
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.lang.String getCreatedBy () {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getCreatedBy ()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.createdBy;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	protected void setCreatedBy (java.lang.String createdBy) {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":setCreatedBy (java.lang.String)";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, new Object[] {this.createdBy}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("createdBy", this.createdBy);
			}
			this.createdBy = createdBy;
			if (notifEnabled) {
				notifEvent.registerNewValue("createdBy", this.createdBy);
			}
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.lang.String getRateType () {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getRateType ()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.rateType;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void setRateType (java.lang.String rateType) {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":setRateType (java.lang.String)";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, new Object[] {this.rateType}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("rateType", this.rateType);
			}
			this.rateType = rateType;
			if (notifEnabled) {
				notifEvent.registerNewValue("rateType", this.rateType);
			}
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.lang.String getDate () {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getDate ()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.date;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void setDate (java.lang.String date) {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":setDate (java.lang.String)";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, new Object[] {this.date}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("date", this.date);
			}
			this.date = date;
			if (notifEnabled) {
				notifEvent.registerNewValue("date", this.date);
			}
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.math.BigDecimal getFactorFrom () {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getFactorFrom ()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.factorFrom;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void setFactorFrom (java.math.BigDecimal factorFrom) {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":setFactorFrom (java.math.BigDecimal)";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, new Object[] {this.factorFrom}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("factorFrom", this.factorFrom);
			}
			this.factorFrom = factorFrom;
			if (notifEnabled) {
				notifEvent.registerNewValue("factorFrom", this.factorFrom);
			}
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.lang.String getCurrencyTo () {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getCurrencyTo ()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.currencyTo;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void setCurrencyTo (java.lang.String currencyTo) {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":setCurrencyTo (java.lang.String)";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, new Object[] {this.currencyTo}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("currencyTo", this.currencyTo);
			}
			this.currencyTo = currencyTo;
			if (notifEnabled) {
				notifEvent.registerNewValue("currencyTo", this.currencyTo);
			}
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

// *** Generic GET/SET methods ***
	public Object getProperty(java.lang.String propertyName) {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getProperty(java.lang.String)";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, new Object[] {propertyName}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			Object prop = null;
			if (propertyName.equals("key")) {
				prop = this.getKey();
			} else if (propertyName.equals("lastChangedAt")) {
				prop = this.getLastChangedAt();
			} else if (propertyName.equals("exchangeRate")) {
				prop = this.getExchangeRate();
			} else if (propertyName.equals("currencyFrom")) {
				prop = this.getCurrencyFrom();
			} else if (propertyName.equals("factorTo")) {
				prop = this.getFactorTo();
			} else if (propertyName.equals("lastChangedBy")) {
				prop = this.getLastChangedBy();
			} else if (propertyName.equals("createdAt")) {
				prop = this.getCreatedAt();
			} else if (propertyName.equals("createdBy")) {
				prop = this.getCreatedBy();
			} else if (propertyName.equals("rateType")) {
				prop = this.getRateType();
			} else if (propertyName.equals("date")) {
				prop = this.getDate();
			} else if (propertyName.equals("factorFrom")) {
				prop = this.getFactorFrom();
			} else if (propertyName.equals("currencyTo")) {
				prop = this.getCurrencyTo();
			}
			return prop;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void setProperty(java.lang.String propertyName, Object propertyValue) {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":setProperty(java.lang.String, Object)";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, new Object[] {propertyName, propertyValue}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (propertyName.equals("key")) {
				this.setKey((java.lang.String) propertyValue);
			} else if (propertyName.equals("exchangeRate")) {
				this.setExchangeRate((java.math.BigDecimal) propertyValue);
			} else if (propertyName.equals("currencyFrom")) {
				this.setCurrencyFrom((java.lang.String) propertyValue);
			} else if (propertyName.equals("factorTo")) {
				this.setFactorTo((java.math.BigDecimal) propertyValue);
			} else if (propertyName.equals("rateType")) {
				this.setRateType((java.lang.String) propertyValue);
			} else if (propertyName.equals("date")) {
				this.setDate((java.lang.String) propertyValue);
			} else if (propertyName.equals("factorFrom")) {
				this.setFactorFrom((java.math.BigDecimal) propertyValue);
			} else if (propertyName.equals("currencyTo")) {
				this.setCurrencyTo((java.lang.String) propertyValue);
				}
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void jdoPostLoad() {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":jdoPostLoad()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void jdoPreClear() {
	}

	public void jdoPreStore() {
	}

	public void jdoPreDelete() {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":jdoPreDelete()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			IDataAccessService dataAccessService = null;
			HashSet relKeySet = null;
			java.lang.String relKey = null;
		
			try {
				dataAccessService = DataAccessFactory.getDataAccessService(DataAccessFactory.DATASOURCE_LOCAL);


				if (notifEnabled) {
					notifEvent.setType(BOSubscrType.DELETED);
				}
			} catch (Exception e) {
				CAFPublicLogger.traceThrowableT(Severity.DEBUG, ExchangeRate.LOCATION, method, "Error in " + method, e);
			}
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public IBOChangedEvent getNotifEvent() {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":getNotifEvent()";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return notifEvent;
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void setNotifEvent(IBOChangedEvent event) {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":setNotifEvent(IBOChangedEvent)";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, new Object[] {event}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			notifEvent = event;
			notifEnabled = event!=null && event.isEnabled();
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	void copyContentFrom(ExchangeRate source) throws CAFBaseException {
		java.lang.String method = ExchangeRate.JARM_REQUEST + ":copyContentFrom(ExchangeRate)";
		CAFPublicLogger.entering(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, new Object[] {source}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			this.setLastChangedAt(source.getLastChangedAt());
			this.setExchangeRate(source.getExchangeRate());
			this.setCurrencyFrom(source.getCurrencyFrom());
			this.setFactorTo(source.getFactorTo());
			this.setLastChangedBy(source.getLastChangedBy());
			this.setCreatedAt(source.getCreatedAt());
			this.setCreatedBy(source.getCreatedBy());
			this.setRateType(source.getRateType());
			this.setDate(source.getDate());
			this.setFactorFrom(source.getFactorFrom());
			this.setCurrencyTo(source.getCurrencyTo());
			this.setKey(source.getKey());
			this.setNotifEvent(source.getNotifEvent());
		} finally {
			CAFPublicLogger.exiting(null, ExchangeRate.JARM_REQUEST, method, ExchangeRate.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}
	
	
	public boolean equals( Object o ) {
		if ( o == null ) {
			return false;
		}
		if ( ! this.getClass().equals( o.getClass() ) ) {
			return false;
		}
		
		ExchangeRate otherObj = ((ExchangeRate)o);
		boolean bEqual = this.getPK().equals( otherObj.getPK() );
		
		if ( bEqual ) {
			java.util.List attr = getPropertyList();
			java.util.Iterator it = attr.iterator();		
			
			while( it.hasNext() && bEqual ) {
				String attrName = (String)it.next();
				Object attr1 = getProperty( attrName );
				Object attr2 = otherObj.getProperty( attrName );
			
				if ( ( attr1 != null ) && ( attr2 != null ) ) {
					bEqual = attr1.equals( attr2 );
				}
				else {
					bEqual = ( attr1 == attr2 );
				}
			}
		}
		return bEqual;
	}	
	
	
	public int hashCode() {
		return this.getPK().hashCode();	
	}	
}