package com.sap.caf.core.besrv.document;

import java.util.Collection;
import java.util.Map;

import javax.ejb.EJBLocalObject;
import javax.ejb.FinderException;

import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.exception.BEException;
import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.CAFDeleteException;
import com.sap.caf.rt.exception.CAFFindException;
import com.sap.caf.rt.exception.CAFRetrieveException;
import com.sap.caf.rt.exception.CAFUpdateException;

public interface DocumentServiceLocal extends EJBLocalObject {

	public Document create(String kmParentFolder, String title) throws CAFCreateException;
	public Document read(String key) throws CAFRetrieveException;
	public void update(Document document) throws CAFUpdateException;
	public void delete(Document document) throws CAFDeleteException;

	public Collection findByDocumentKey(String documentKey) throws CAFFindException;
	public Collection findByDocumentId(String parentFolder, String documentId) throws CAFFindException;
	public Collection findByTitle(String parentFolder, String title) throws CAFFindException;
	public Collection findByRid(String parentFolder) throws CAFFindException;	
	
	/* Following methods are implemented at EntityServiceBase*/
	public Collection findByKMPropertySearch(
		Map mapAttributeNameToFilter,
		Map mapCategoryNameToFilter)
		throws FinderException, CAFFindException;

	public Collection searchidxForBOInRelatedDoc(String freeText)
		throws BEException;		
		
	/** KM Part - searchidxForSimilar */
	public Collection searchidxForSimilar( IBusinessObject thisCourse, int maxResults ) 
		throws BEException;
		
	/** KM Part - classification method - getCategories */	
	public Collection getCategories() 
		throws BEException;
	
	/** KM Part - classification method - getClassification */	
	public Collection getClassification( String boPrimaryKey, String categoryGUID ) 
		throws BEException;
	
	/** KM Part - classification method - addClassification */	
	public void addClassification( String boPrimaryKey, String valueGUID, String categoryGUID )
		 throws BEException;
		 
	/** KM Part - classification method - removeClassification */	
	public void removeClassification( String boPrimaryKey, String valueGUID ) 
		throws BEException;		
		
}


