package com.sap.caf.core.besrv.document;

import java.io.Serializable;
import java.util.*;
import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.pk.AbstractPrimaryKey;

public class DocumentContent implements IBusinessObject, Serializable {

	private transient String createdBy;
	private transient Date createdAt;
	private transient String lastChangedBy;
	private transient Date lastChangedAt;

	public static final String APPLICATION = "caf.core";	
	public static final String OBJECT_NAME = "sap.com/caf.core/DocumentContent";	
	public static final String JARM_REQUEST = "XAP:BO:" + OBJECT_NAME;
	private static final String separator = "/";	

	// KM attributes
	private String documentId;
	private String parentFolder;
	private String key;
	
	private transient Collection relatedObjectRids = new java.util.HashSet();	
	
	private transient java.lang.String title;
	private transient java.lang.String description;
	private transient DocumentContent documentContent;	
	private transient java.lang.String link;
	
	private transient byte[] content;
	private transient java.lang.String contentEncoding;
	private transient java.lang.String contentType;
	private transient long contentLength;
	
	private static List propList = new ArrayList();
	
	static {
		propList.add("key");
		propList.add("parentFolder");
		propList.add("createdBy");
		propList.add("createdAt");
		propList.add("lastChangedBy");
		propList.add("lastChangedAt");		
		propList.add("documentId");		
		propList.add("title");
		propList.add("description");		
		propList.add("link");
		propList.add("relatedObjects");		
		//related to content					
		propList.add("content");
		propList.add("contentEncoding");
		propList.add("contentType");
		propList.add("contentLength");		
	}
	
	public DocumentContent() {
	}	
	
	public DocumentContent(String id) {
		documentId = id;
		key = id;
	}
			
	public String getObjectType() {
		return OBJECT_NAME;
	}

	public void setKey(String key) {
		this.key = key;		
/*		
		//this.key = key;		
		//setParentFolder by Inheritance
		int keyLength = 0;
		int keyLastSeparator = 0;			
		keyLength = key.length();
		if (keyLength == 0) {
			this.setParentFolder("");
		} else {			
			keyLastSeparator = key.lastIndexOf(separator);	
			//RID ends with "/"?			
			if (keyLastSeparator == keyLength-1) {
				keyLastSeparator = key.lastIndexOf(separator, keyLength-1);
			}
			this.setParentFolder(key.substring(0, keyLastSeparator));	
		}		
		//setDocumentId by Inheritance	
		keyLength = 0;
		keyLastSeparator = 0;			
		keyLength = key.length();
		if (keyLength == 0) {
			this.setDocumentId("");
		} else {			
			keyLastSeparator = key.lastIndexOf(separator);	
			//RID ends with "/"?			
			if (keyLastSeparator == keyLength-1) {
				keyLastSeparator = key.lastIndexOf(separator, keyLength-1);						
			} 
			this.setDocumentId(key.substring(keyLastSeparator + 1));
		}
*/		
	}

	public String getKey() {
		return key;  	
	}
	
	public void setParentFolder(String parentFolder) {
		this.parentFolder = parentFolder;
	}

	public String getParentFolder() {
		return parentFolder;
	}	

	public void setDocumentId(String documentId) {
		this.documentId = documentId;
	}
	
	public String getDocumentId() {
		return documentId;
	} 

	public String getRid() {
		return this.parentFolder.concat(separator).concat( getDocumentId() );
	}

	public java.lang.String getCreatedBy() {
		return createdBy;
	}
	
	public void setCreatedBy(java.lang.String createdBy) {
		this.createdBy = createdBy;
	}

	public java.util.Date getCreatedAt() {
		return createdAt;
	}
	
	public void setCreatedAt(java.util.Date createdAt) {
		this.createdAt = createdAt;
	}

	public java.lang.String getLastChangedBy() {
		return lastChangedBy;
	}
	public void setLastChangedBy(java.lang.String lastChangedBy) {
		this.lastChangedBy = lastChangedBy;
	}

	public java.util.Date getLastChangedAt() {
		return lastChangedAt;
	}
	
	public void setLastChangedAt(java.util.Date lastChangedAt) {
		this.lastChangedAt = lastChangedAt;
	}

	public void addRelatedObjectRids(java.lang.String relatedObjectRid) {
		this.relatedObjectRids.add( relatedObjectRid );
	}
	
	public void removeRelatedObjectRids(java.lang.String relatedObjectRid) {
		this.relatedObjectRids.remove( relatedObjectRid );
	}
	
	public Collection getRelatedObjectRids() {
		return relatedObjectRids;
	}
	
	public void setRelatedObjectRids(Collection rids) {
		relatedObjectRids = rids;
	}

		
	public java.lang.String getTitle()  {
		return title;
	}
		
	public void setTitle(java.lang.String title) {
		this.title = title;
	}
		
	public java.lang.String getDescription()  {
		return description;
	}
		
	public void setDescription(java.lang.String description) {
		this.description = description;
	}
				
	public java.lang.String getLink()  {
		return link;
	}
		
	public void setLink(java.lang.String link) {
		this.link = link;
	}
		
	
	public Object getProperty(String propertyName){
		//BOPublicLogger.Loc.entering("getProperty(String)");
		Object prop = null; 
		if (propertyName.equals("key")) { prop =  (Object)this.getKey();}
		else if(propertyName.equals("parentFolder")) { prop = (Object)this.getParentFolder();}
		else if	(propertyName.equals("documentId")) { prop =  (Object) this.getDocumentId();}				
		else if (propertyName.equals("createdBy")) { prop =  (Object) this.getCreatedBy();}
		else if (propertyName.equals("createdAt")) { prop =  (Object) this.getCreatedAt();}
		else if (propertyName.equals("lastChangedBy")) { prop =  (Object) this.getLastChangedBy();}
		else if (propertyName.equals("lastChangedAt")) { prop =  (Object) this.getLastChangedAt();}	
		else if (propertyName.equals("title")) 	{prop = this.getTitle();}
		else if (propertyName.equals("description")) {prop = this.getDescription();}
		else if (propertyName.equals("link")) {prop = this.getLink();}
		else if (propertyName.equals("content")) { prop = getContent();}
		else if (propertyName.equals("contentEncoding")) { prop = getContentEncoding();}
		else if (propertyName.equals("contentType")) {prop = getContentType();}
		else if (propertyName.equals("contentLength")){prop = new Long(getContentLength());}
		else if (propertyName.equals("relatedObjects")){prop = getRelatedObjectRids();}		

		return prop;		
	}

	public void setProperty(String propertyName, Object propertyValue) {
		if (propertyName.equals("createdBy")) { this.setCreatedBy((String)propertyValue);}
		else if (propertyName.equals("createdAt")) { this.setCreatedAt((Date)propertyValue);}
		else if (propertyName.equals("lastChangedBy")) { this.setLastChangedBy((String)propertyValue);}
		else if (propertyName.equals("lastChangedAt")) { this.setLastChangedAt((Date)propertyValue);}
		else if	(propertyName.equals("documentId")) { this.setDocumentId((String)propertyValue);}
		else if (propertyName.equals("parentFolder")) { this.setParentFolder((String)propertyValue);}
		else if (propertyName.equals("title")) { this.setTitle((java.lang.String)propertyValue);}
		else if (propertyName.equals("description")) { this.setDescription((java.lang.String)propertyValue);}
		else if (propertyName.equals("link")) { this.setLink((java.lang.String)propertyValue);}
		else if (propertyName.equals("content")) { setContent((byte[])propertyValue);}
		else if (propertyName.equals("contentEncoding")) { setContentEncoding((java.lang.String)propertyValue);}
		else if (propertyName.equals("contentType")) { setContentType((java.lang.String)propertyValue);}
		else if (propertyName.equals("contentLength")) { setContentLength(((Number)propertyValue).longValue());}		
		else if (propertyName.equals("relatedObjects")) { setRelatedObjectRids((Collection)propertyValue);}		
	}

	public boolean validate() {
		return true;
	}
	
	/** 
	 * @see com.sap.caf.rt.bol.IDependentObject#getPK()
	 */
	public AbstractPrimaryKey getPK() {
		// TODO Auto-generated method stub
		return new DocumentPK(getKey());
	}
	
	public byte[] getContent()  {
		return content;
	}
		
	public void setContent(byte[] content) {
		this.content = content;
		this.contentLength = content.length;
	}
		
	public java.lang.String getContentEncoding()  {
		return contentEncoding;
	}
		
	public void setContentEncoding(java.lang.String contentEncoding) {
		this.contentEncoding = contentEncoding;
	}
		
	public java.lang.String getContentType()  {
		return contentType;
	}
		
	public void setContentType(java.lang.String contentType) {
		this.contentType = contentType;
	}
		
	public long getContentLength()  {
		return contentLength;
	}
		
	public void setContentLength(long contentLength) {
		this.contentLength = contentLength;
	}
			
	public List getPropertyList() {
		return propList;
	}		
}