package com.sap.caf.core.besrv.document;

import java.io.Serializable;
import java.util.*;
		
import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.IKMExt;
import com.sap.caf.rt.bol.pk.AbstractPrimaryKey;

public class Document implements IBusinessObject, Serializable, IKMExt {

	private transient String createdBy;
	private transient Date createdAt;
	private transient String lastChangedBy;
	private transient Date lastChangedAt;

//	public static final String APPLICATION = Document.class.getName();	
	
	public static final String APPLICATION = "caf.core";	
	public static final String OBJECT_NAME = "sap.com/caf.core/Document";
	public static final java.lang.String objectGuid = "33957551E5A5044CFA78C05ABEE43565";
	public static final java.lang.String PROVIDER = "sap.com";
	public static final java.lang.String BE_SRV_NAME = "Document";
		
	public static final String JARM_REQUEST = "XAP:BO:" + OBJECT_NAME;
	public static final String SEPARATOR = "/";

	// KM attributes
	private String key;
	private String parentFolder;
	private String documentId;

	private transient ArrayList relatedObjectRids = new ArrayList();
	private transient java.lang.String title;
	private transient java.lang.String description;
//--	private transient DocumentContent documentContent;	
	private transient java.lang.String link;
	private transient long contentLength;
	private transient java.lang.String contentType;

	private static List propList = new ArrayList();
	
	static {
		propList.add("key");
		propList.add("parentFolder");
		propList.add("createdBy");
		propList.add("createdAt");
		propList.add("lastChangedBy");
		propList.add("lastChangedAt");		
		propList.add("documentId");		
		propList.add("title");
		propList.add("description");		
//--		propList.add("documentContent"); //instance of DocumentContent object
		propList.add("link");
		propList.add("contentLength");
		propList.add("contentType");
		propList.add("relatedObjects");
	}
	
	public Document() {
	}

	/**
	 * Constructor
	 * 
	 * @param id			Document KEY.
	 */			
	public Document(String key) {
		this.key = key;
		this.documentId = key;
	}

	/**
	 * @see IBusinessObject.getObjectType()
	 */
	public String getObjectType() {
		return OBJECT_NAME;
	}

	/**
	 * Set Document Key.  
	 * 
	 * @param key	Document Key.  
	 */
	public void setKey(String key) {
		this.key = key;
	}

	public String getKey() {
		return key;
	}
	
	public void setParentFolder(String parentFolder) {
		this.parentFolder = parentFolder;
	}

	public String getParentFolder() {
		return parentFolder;
	}	

	public void setDocumentId(String documentId) {
		this.documentId = documentId;
	}
	
	public String getDocumentId() {
		return this.documentId;
	} 

	public String getRid() {
		return this.parentFolder.concat(SEPARATOR).concat( getDocumentId() );
	}

	public java.lang.String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(java.lang.String createdBy) {
		this.createdBy = createdBy;
	}

	public java.util.Date getCreatedAt() {
		return createdAt;
	}
	
	public void setCreatedAt(java.util.Date createdAt) {
		this.createdAt = createdAt;
	}

	public java.lang.String getLastChangedBy() {
		return lastChangedBy;
	}
	public void setLastChangedBy(java.lang.String lastChangedBy) {
		this.lastChangedBy = lastChangedBy;
	}

	public java.util.Date getLastChangedAt() {
		return lastChangedAt;
	}
	
	public void setLastChangedAt(java.util.Date lastChangedAt) {
		this.lastChangedAt = lastChangedAt;
	}

	public void addRelatedObjectRids(java.lang.String relatedObjectRid) {
		relatedObjectRids.add( relatedObjectRid );
	}
	
	public void removeRelatedObjectRids(java.lang.String relatedObjectRid) {
		relatedObjectRids.remove( relatedObjectRid );
	}
	
	public Collection getRelatedObjectRids() {
		return relatedObjectRids;
	}
	
	public void setRelatedObjectRids(Collection rids) {
		relatedObjectRids = new ArrayList(rids);
	}
		
	public java.lang.String getTitle()  {
		return title;
	}
		
	public void setTitle(java.lang.String title) {
		this.title = title;
	}
		
	public java.lang.String getDescription()  {
		return description;
	}
		
	public void setDescription(java.lang.String description) {
		this.description = description;
	}

/*		
	public DocumentContent getDocumentContent() throws DataAccessException {
		if (this.documentContent == null ) {
			DocumentDataAccessService service = DocumentDataAccessService.getInstance();
			documentContent = (DocumentContent)service.load(new DocumentContentPK(getKey()), DocumentContent.class);
		}
		return documentContent;
	}
		
	public void setDocumentContent(DocumentContent documentContent) {
		this.documentContent = documentContent;
	}
*/
				
	public java.lang.String getLink()  {
		return link;
	}
		
	public void setLink(java.lang.String link) {
		this.link = link;
	}

	public long getContentLength()  {
		return contentLength;
	}
		
	public void setContentLength(long contentLength) {
		this.contentLength = contentLength;
	}

	public java.lang.String getContentType()  {
		return contentType;
	}
		
	public void setContentType(java.lang.String contentType) {
		this.contentType = contentType;
	}
		
	public List getPropertyList() {	
		return propList;
	}
	
	public Object getProperty(String propertyName){
		Object prop = null; 
		if (propertyName.equals("key")) { prop =  this.getKey();}
		else if(propertyName.equals("parentFolder")) { prop = this.getParentFolder();}
		else if	(propertyName.equals("documentId")) { prop = this.getDocumentId();}				
		else if (propertyName.equals("createdBy")) { prop = this.getCreatedBy();}
		else if (propertyName.equals("createdAt")) { prop = this.getCreatedAt();}
		else if (propertyName.equals("lastChangedBy")) { prop = this.getLastChangedBy();}
		else if (propertyName.equals("lastChangedAt")) { prop = this.getLastChangedAt();}	
		else if (propertyName.equals("title")) 	{prop = this.getTitle();}
		else if (propertyName.equals("description")) {prop = this.getDescription();}
		else if (propertyName.equals("link")) {prop = this.getLink();}
		else if (propertyName.equals("contentLength")) {prop = new java.lang.Long(this.getContentLength());}
		else if (propertyName.equals("contentType")) {prop = this.getContentType();}
		else if (propertyName.equals("relatedObjects")){prop = getRelatedObjectRids();}

		return prop;		
	}

	public void setProperty(String propertyName, Object propertyValue) {
		if (propertyName.equals("createdBy")) { this.setCreatedBy((String)propertyValue);}
		else if (propertyName.equals("createdAt")) { this.setCreatedAt((Date)propertyValue);}
		else if (propertyName.equals("lastChangedBy")) { this.setLastChangedBy((String)propertyValue);}
		else if (propertyName.equals("lastChangedAt")) { this.setLastChangedAt((Date)propertyValue);}
 		else if	(propertyName.equals("documentId")) { this.setDocumentId((String)propertyValue);}
 		else if (propertyName.equals("parentFolder")) { this.setParentFolder((String)propertyValue);}
		else if (propertyName.equals("key")) { this.setKey((String)propertyValue);}
		else if (propertyName.equals("title")) { this.setTitle((java.lang.String)propertyValue);}
		else if (propertyName.equals("description")) { this.setDescription((java.lang.String)propertyValue);}
		else if (propertyName.equals("link")) { this.setLink((java.lang.String)propertyValue);}
		else if (propertyName.equals("contentLength")) { this.setContentLength(((java.lang.Number) propertyValue).intValue());}
		else if (propertyName.equals("contentType")) { this.setContentType((java.lang.String)propertyValue);}
		else if (propertyName.equals("relatedObjects")) { setRelatedObjectRids((Collection)propertyValue);}
	}

	public boolean validate() {
		return true;
	}

	public AbstractPrimaryKey getPK() {
		return new DocumentPK(getKey());
	}
}