/*
 * Created on 12.08.2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.caf.core.besrv.discussionroom;

import java.util.Collection;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;

import com.sap.caf.core.CoreServices;
import com.sap.caf.km.ejb.svc.kmcoll.DiscussionHeader;
import com.sap.caf.km.ejb.svc.kmcoll.RoomHeader;
import com.sap.caf.rt.bol.EntityServiceBase;
import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.CAFDeleteException;
import com.sap.caf.rt.exception.CAFRetrieveException;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @author valery_tadra
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */

/**
 * @ejbLocal <{com.sap.caf.core.besrv.discussionroom.DiscussionRoomServiceLocal}>
 * @ejbLocalHome <{com.sap.caf.core.besrv.discussionroom.DiscussionRoomServiceLocalHome}>
 * @stateless 
 */
public class DiscussionRoomServiceBean   extends EntityServiceBase implements SessionBean {

	private static final Location location = Location.getLocation(DiscussionRoomServiceBean.class);
	
	public void ejbCreate() throws CreateException {
	}
	
	public void ejbRemove() {
	}
	
	public void ejbActivate() {
	}
	
	public void ejbPassivate() {
	}


	public DiscussionRoom create(String name, String description, Collection team, String relatedObjectRid) throws CAFCreateException {
		String method = "create(String name, String description, Collection team)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			DiscussionRoom.JARM_REQUEST,
			method,
			location,
			new Object[] { name, description, team});
				
		DiscussionRoom discussionRoom = null;
					
		try {
			
			RoomHeader header = CoreServices.getCollaborationService().
						createDiscussionRoom(name, description, team, relatedObjectRid);
			
			discussionRoom = new DiscussionRoom(header);			
				
				
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(
				user,
				DiscussionRoom.JARM_REQUEST,
				method,
				location);
			throw new CAFCreateException("BO_CREATE", e);
		}
	
			
		CAFPublicLogger.exiting(
			user,
			DiscussionRoom.JARM_REQUEST,
			method,
			location,
			new Object[] { discussionRoom });
		return discussionRoom;		
	}
	
	public DiscussionRoom read(String key) throws CAFRetrieveException {
		String method = "read(String)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			DiscussionRoom.JARM_REQUEST,
			method,
			location,
			new Object[] { key });
		
		DiscussionRoom room = null;
		try {
			RoomHeader header = CoreServices.getCollaborationService().findDiscussionRoom(key);
			if (header != null){
				room = new DiscussionRoom(header);
			}				
								
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(
				user,
				DiscussionRoom.JARM_REQUEST,
				method,
				location);
			throw new CAFRetrieveException("BO_READ", e);
		}
	
		CAFPublicLogger.exiting(
			user,
			DiscussionRoom.JARM_REQUEST,
			method,
			location,
			new Object[] { room });
		return room;
	}
	
	public void update(DiscussionRoom room) throws CAFUpdateException {
		String method = "update(DiscussionRoom)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			DiscussionRoom.JARM_REQUEST,
			method,
			location,
			new Object[] { room });
				
		try {
			CoreServices.getCollaborationService().updateDiscussionRoom(room.getKey(), room.getName(), room.getDescription(), room.getRelatedObjectRid());
			CoreServices.getCollaborationService().assignUsers(room.getKey(), room.getTeam());
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(
				user,
				DiscussionRoom.JARM_REQUEST,
				method,
				location);
			throw new CAFUpdateException("BO_UPDATE", e);
		}
			
		CAFPublicLogger.exiting(user, DiscussionRoom.JARM_REQUEST, method, location);	
	}
		
		
	public void delete(DiscussionRoom room) throws CAFDeleteException {
		String method = "delete(DiscussionRoom)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			DiscussionRoom.JARM_REQUEST,
			method,
			location,
			new Object[] { room });
	
		try {
			CoreServices.getCollaborationService().deleteDiscussionRoom(room.getKey());
				
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(
				user,
				DiscussionRoom.JARM_REQUEST,
				method,
				location);
			throw new CAFDeleteException(e);
		}
	
		CAFPublicLogger.exiting(user, DiscussionRoom.JARM_REQUEST, method, location);
	}
	
	public DiscussionRoom findByDiscussionRoomForDashboard(String key) throws CAFRetrieveException {
		String method = "findByDiscussionRoomForDashboard(String)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			DiscussionRoom.JARM_REQUEST,
			method,
			location,
			new Object[] { key });
		
		DiscussionRoom room = null;
		try {
			RoomHeader header = CoreServices.getCollaborationService().findRoomWithTodayPosts(key);
			if (header != null){
				room = new DiscussionRoom(header);
			}				
								
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(
				user,
				DiscussionRoom.JARM_REQUEST,
				method,
				location);
			throw new CAFRetrieveException("BO_READ", e);
		}
	
		CAFPublicLogger.exiting(
			user,
			DiscussionRoom.JARM_REQUEST,
			method,
			location,
			new Object[] { room });
		return room;
	}
}
