/*
 * Created on 12.08.2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.caf.core.besrv.discussionroom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import com.sap.caf.km.ejb.svc.kmcoll.RoomHeader;
import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.pk.AbstractPrimaryKey;


/**
 * @author valery_tadra
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class DiscussionRoom implements IBusinessObject, Serializable {

	private transient String createdBy;
	private transient Date createdAt;
	private transient String lastChangedBy;
	private transient Date lastChangedAt;

	private String key;
	private String name;
	private String rid;
	private String relatedObjectRid;
	private String description;
	private Integer todayPostsCount;
	
	private ArrayList discussions = new ArrayList();
	private ArrayList team = new ArrayList();

	private static List propList = new ArrayList();
	
	private static final String APPLICATION	= "com.sap.caf.core.services.DiscussionRoom";
	public static final String JARM_REQUEST = "XAP:SRV:" + APPLICATION;
	public static final String OBJECT_NAME = "sap.com/caf.core/DiscussionRoom";
	public static final String SEPARATOR = "/";
	
	static {
		propList.add("key");
		propList.add("name");
		propList.add("rid");
		propList.add("relatedObjectRid");
		propList.add("description");
		propList.add("todayPostsCount");
		propList.add("discussions");
		propList.add("team");
		propList.add("createdBy");
		propList.add("createdAt");
		propList.add("lastChangedBy");
		propList.add("lastChangedAt");		
	}
	   		
	public DiscussionRoom() {
	}

	public DiscussionRoom(String key) {
		this.key = key;
	}
	
	public DiscussionRoom(RoomHeader header) {
		
		this.setKey(header.getId());
		this.setRid(header.getId());
		this.setRelatedObjectRid(header.getRelatedRid());
		this.setDescription(header.getDescription());
		this.setName(header.getTitle());
		this.createdAt = header.getCreatedAt();
		this.createdBy = header.getCreatedBy();
		this.lastChangedAt = header.getLastChangedAt();
		this.lastChangedBy = header.getLastChangedBy();
		
		setTodayPostsCount(new Integer(header.getTodayPostsCount()));

		if (header.getTeam() != null){
			this.team = new ArrayList(header.getTeam());
		}
		
		if (header.getDiscussions() != null){
			this.discussions = new ArrayList(header.getDiscussions());
		}
	}
	
	/**
		* @see IBusinessObject.getObjectType()
	*/
	public String getObjectType() {
		return OBJECT_NAME;
	}
	
	public java.lang.String getKey() {
		return key;
	}

	public void setKey(java.lang.String string) {
		key = string;
	}
	
	public java.lang.String getName() {
		return name;
	}

	public void setName(java.lang.String string) {
		name = string;
	}

	public java.lang.String getRid() {
		return rid;
	}

	public void setRid(java.lang.String string) {
		rid = string;
	}
	
	public java.lang.String getRelatedObjectRid() {
		return relatedObjectRid;
	}

	public void setRelatedObjectRid(java.lang.String string) {
		relatedObjectRid = string;
	}
	
	/**
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @param string
	 */
	public void setDescription(String string) {
		description = string;
	}
	
	public Integer getTodayPostsCount()
	{
		return todayPostsCount;
	}
	
	public void setTodayPostsCount(Integer postsCount) {
		todayPostsCount = postsCount;
	}
	
	public void addDiscussion(java.lang.String discussion) {
		this.discussions.add( discussion );
	}
	
	public void removeDiscussion(java.lang.String discussion) {
		this.discussions.remove( discussion );
	}
	
	public void setDiscussions(Collection discussions) {
		this.discussions = new ArrayList(discussions);
	}	
	
	public java.util.ArrayList getDiscussions() {
		return new ArrayList(discussions);
	}


	public void addTeam(java.lang.String team) {
		this.team.add( team );
	}
	
	public void removeTeam(java.lang.String team) {
		this.team.remove( team );
	}
	
	public void setTeam(Collection team) {
		this.team = new ArrayList(team);
	}	
	
	public java.util.ArrayList getTeam() {
		return new ArrayList(team);
	}
	
	public java.lang.String getCreatedBy() {
		return createdBy;
	}
	
	public void setCreatedBy(java.lang.String createdBy) {
		this.createdBy = createdBy;
	}

	public java.util.Date getCreatedAt() {
		return createdAt;
	}
	
	public void setCreatedAt(java.util.Date createdAt) {
		this.createdAt = createdAt;
	}

	public java.lang.String getLastChangedBy() {
		return lastChangedBy;
	}
	public void setLastChangedBy(java.lang.String lastChangedBy) {
		this.lastChangedBy = lastChangedBy;
	}

	public java.util.Date getLastChangedAt() {
		return lastChangedAt;
	}
	
	public void setLastChangedAt(java.util.Date lastChangedAt) {
		this.lastChangedAt = lastChangedAt;
	}


	
	public boolean validate() {
		return true;
	}
	/* (non-Javadoc)
	 * @see com.sap.caf.rt.bol.IDependentObject#getPK()
	 */
	public AbstractPrimaryKey getPK() {
		return new DiscussionRoomPK(getKey());
	}
	
	public List getPropertyList() {	
		return propList;
	}
	
	public Object getProperty(String propertyName) {
		String method = "getProperty()";
		//BOPublicLogger.entering(null, jARMRequest, method, APPLICATION);

		Object prop = null;
		if (propertyName.equals("key")) { prop =  this.getKey();}
		else if (propertyName.equals("name")) { prop = this.getName();}
		else if (propertyName.equals("rid")) { prop = this.getRid();}
		else if (propertyName.equals("relatedObjectRid")) { prop = this.getRelatedObjectRid();}
		else if (propertyName.equals("todayPostsCount")) { prop = this.getTodayPostsCount();}
		else if (propertyName.equals("discussions")) { prop = this.getDiscussions();}
		else if (propertyName.equals("team")) { prop = this.getTeam();}
		else if (propertyName.equals("description")) { prop = this.getDescription();}
		else if (propertyName.equals("createdBy")) { prop = this.getCreatedBy();}
		else if (propertyName.equals("createdAt")) { prop = this.getCreatedAt();}
		else if (propertyName.equals("lastChangedBy")) { prop = this.getLastChangedBy();}
		else if (propertyName.equals("lastChangedAt")) { prop = this.getLastChangedAt();}
		
		//BOPublicLogger.exiting(null, jARMRequest, method, APPLICATION);
		
		return prop;
	}

	public void setProperty(String propertyName, Object propertyValue) {
		String method = "setProperty()";
		//BOPublicLogger.entering(null, jARMRequest, method, APPLICATION);

		if (propertyName.equals("createdBy")) { this.setCreatedBy((String)propertyValue);}
		else if (propertyName.equals("createdAt")) { this.setCreatedAt((Date)propertyValue);}
		else if (propertyName.equals("lastChangedBy")) { this.setLastChangedBy((String)propertyValue);}
		else if (propertyName.equals("lastChangedAt")) { this.setLastChangedAt((Date)propertyValue);}
		else if (propertyName.equals("key")) { this.setKey((String)propertyValue);}
		else if (propertyName.equals("name")) { this.setName((java.lang.String)propertyValue);}
		else if (propertyName.equals("description")) { this.setDescription((java.lang.String)propertyValue);}
		else if (propertyName.equals("rid")) { this.setRid((java.lang.String)propertyValue);}
		else if (propertyName.equals("relatedObjectRid")) { this.setRelatedObjectRid((java.lang.String)propertyValue);}
		else if (propertyName.equals("todayPostsCount")) { this.setTodayPostsCount((java.lang.Integer)propertyValue);}
		
		else if (propertyName.equals("discussions")) { setDiscussions((Collection)propertyValue);}		
		else if (propertyName.equals("team")) { setTeam((Collection)propertyValue);}
	}

}
