/*
 * Created on 12.08.2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.caf.core.besrv.discussion;

import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.SessionBean;

import com.sap.caf.core.CoreServices;
import com.sap.caf.km.ejb.svc.kmcoll.DiscussionHeader;
import com.sap.caf.rt.bol.EntityServiceBase;
import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.CAFDeleteException;
import com.sap.caf.rt.exception.CAFRetrieveException;
import com.sap.caf.rt.exception.CAFUpdateException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @author valery_tadra
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */

/**
 * @ejbLocal <{com.sap.caf.core.besrv.discussion.DiscussionServiceLocal}>
 * @ejbLocalHome <{com.sap.caf.core.besrv.discussion.DiscussionServiceLocalHome}>
 * @stateless 
 */
public class DiscussionServiceBean  extends EntityServiceBase implements SessionBean {

	private static final Location location = Location.getLocation(DiscussionServiceBean.class);
	
	public void ejbCreate() throws CreateException {
	}

	public void ejbRemove() {
	}

	public void ejbActivate() {
	}

	public void ejbPassivate() {
	}


	public Discussion create(String documentId, String parentFolder) throws CAFCreateException {
		String method = "create(String documentId, String parentFolder)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			Discussion.JARM_REQUEST,
			method,
			location,
			new Object[] { documentId, parentFolder});
			
		Discussion discussion = new Discussion();
		discussion.setParentFolder(parentFolder);
		discussion.setDocumentId(documentId);

		// Set the administrational attributes
		Date changeDate = new Date();
		discussion.setCreatedBy(user);
		discussion.setCreatedAt(changeDate);
		discussion.setLastChangedBy(user);
		discussion.setLastChangedAt(changeDate);		
				
		try {
		
			String discussionRid = CoreServices.getCollaborationService().
						createDiscussion(documentId, parentFolder, documentId);
			
			discussion.setKey(discussionRid);
			
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(
				user,
				Discussion.JARM_REQUEST,
				method,
				location);
			throw new CAFCreateException("BO_CREATE", e);
		}

		
		CAFPublicLogger.exiting(
			user,
			Discussion.JARM_REQUEST,
			method,
			location,
			new Object[] { discussion });
		return discussion;		
	}

	public Discussion read(String key) throws CAFRetrieveException {
		String method = "read(String)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			Discussion.JARM_REQUEST,
			method,
			location,
			new Object[] { key });
	
		Discussion discussion = null;
		try {
			DiscussionHeader header = CoreServices.getCollaborationService().findDiscussion(key);
			if (header != null){
				discussion = new Discussion(header);
			}				
							
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(
				user,
				Discussion.JARM_REQUEST,
				method,
				location);
			throw new CAFRetrieveException("BO_READ", e);
		}

		CAFPublicLogger.exiting(
			user,
			Discussion.JARM_REQUEST,
			method,
			location,
			new Object[] { discussion });
		return discussion;
	}

	public void update(Discussion discussion) throws CAFUpdateException {
		String method = "update(Discussion)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			Discussion.JARM_REQUEST,
			method,
			location,
			new Object[] { discussion });
			
		// not supported
		
		CAFPublicLogger.exiting(user, Discussion.JARM_REQUEST, method, location);	
	}
	
	
	public void delete(Discussion discussion) throws CAFDeleteException {
		String method = "delete(Discussion)";
		String user = sessionContext.getCallerPrincipal().getName();
		CAFPublicLogger.entering(
			user,
			Discussion.JARM_REQUEST,
			method,
			location,
			new Object[] { discussion });

		try {
			CoreServices.getCollaborationService().deleteDiscussion(discussion.getKey());
			
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(
				Severity.DEBUG,
				location,
				method,
				"Error in " + method,
				e);
			location.throwing(method, e);
			CAFPublicLogger.exiting(
				user,
				Discussion.JARM_REQUEST,
				method,
				location);
			throw new CAFDeleteException(e);
		}

		CAFPublicLogger.exiting(user, Discussion.JARM_REQUEST, method, location);
	}

}
