/*
 * Created on 12.08.2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.caf.core.besrv.discussion;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

import com.sap.caf.km.ejb.svc.kmcoll.DiscussionHeader;
import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.pk.AbstractPrimaryKey;

/**
 * @author valery_tadra
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class Discussion implements IBusinessObject, Serializable {


	private transient String createdBy;
	private transient Date createdAt;
	private transient String lastChangedBy;
	private transient Date lastChangedAt;

	private String key;
	private String	documentId;
	private int 	postCount;
	private String parentFolder;
	private String name;
	
	private ArrayList topics = new ArrayList();
	
	private static List propList = new ArrayList();
	
	private static final String APPLICATION	= "com.sap.caf.core.services.Discussion";
	public static final String JARM_REQUEST = "XAP:SRV:" + APPLICATION;
	public static final String OBJECT_NAME = "sap.com/caf.core/Discussion";
	public static final String SEPARATOR = "/";
	
	static {
		propList.add("key");
		propList.add("documentId");
		propList.add("postCount");
		propList.add("parentFolder");
		propList.add("name");
		propList.add("topics");
		propList.add("createdBy");
		propList.add("createdAt");
		propList.add("lastChangedBy");
		propList.add("lastChangedAt");		
	}
		
	public Discussion() {
	}

	public Discussion(String key) {
		this.key = key;
	}
	
	public Discussion(DiscussionHeader header) {
		
		this.documentId = header.getId();
		this.parentFolder = header.getParentFolder();
		this.setKey(header.getParentFolder() + SEPARATOR + header.getId());
		
		this.createdAt = header.getCreatedAt();
		this.createdBy = header.getCreatedBy();
		this.lastChangedAt = header.getLastChangedAt();
		this.lastChangedBy = header.getLastChangedBy();
		this.postCount = header.getSize();
		
		if (header.getTopics() != null){
			this.topics = new ArrayList(header.getTopics());
		}
	}
	
	/**
	 * @see IBusinessObject.getObjectType()
	 */
	public String getObjectType() {
		return OBJECT_NAME;
	}
	
	
	public java.lang.String getKey() {
		return key;
	}

	public void setKey(java.lang.String string) {
		key = string;
	}
	
	public String getRid() {
		return getKey();
	}
	
	public java.lang.String getDocumentId() {
		return documentId;
	}

	public void setDocumentId(java.lang.String string) {
		documentId = string;
	}
	
	public int getPostCount() {
		return postCount;
	}

	public void setPostCount(int value) {
		postCount = value;
	}

	public void addTopic(java.lang.String topic) {
		this.topics.add( topic );
	}
	
	public void removeTopic(java.lang.String topic) {
		this.topics.remove( topic );
	}
	
	
	public void setTopics(Collection topics) {
		topics = new ArrayList(topics);
	}	
	
	public java.util.ArrayList getTopics() {
		return new ArrayList(topics);
	}

	/**
	 * @return
	 */
	public String getParentFolder() {
		return parentFolder;
	}

	/**
	 * @param string
	 */
	public void setParentFolder(String string) {
		parentFolder = string;
	}

	/**
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param string
	 */
	public void setName(String string) {
		name = string;
	}
	
	public java.lang.String getCreatedBy() {
		return createdBy;
	}
	
	public void setCreatedBy(java.lang.String createdBy) {
		this.createdBy = createdBy;
	}

	public java.util.Date getCreatedAt() {
		return createdAt;
	}
	
	public void setCreatedAt(java.util.Date createdAt) {
		this.createdAt = createdAt;
	}

	public java.lang.String getLastChangedBy() {
		return lastChangedBy;
	}
	public void setLastChangedBy(java.lang.String lastChangedBy) {
		this.lastChangedBy = lastChangedBy;
	}

	public java.util.Date getLastChangedAt() {
		return lastChangedAt;
	}
	
	public void setLastChangedAt(java.util.Date lastChangedAt) {
		this.lastChangedAt = lastChangedAt;
	}

	
	
	public boolean validate() {
		return true;
	}
	/* (non-Javadoc)
	 * @see com.sap.caf.rt.bol.IDependentObject#getPK()
	 */
	public AbstractPrimaryKey getPK() {
		return new DiscussionPK(getKey());
	}
	
	public List getPropertyList() {	
		return propList;
	}
	
	public Object getProperty(String propertyName) {
		String method = "getProperty()";
		//BOPublicLogger.entering(null, jARMRequest, method, APPLICATION);

		Object prop = null;
		if (propertyName.equals("key")) { prop =  this.getKey();}
		else if (propertyName.equals("documentId")) { prop = this.getDocumentId();}
		else if (propertyName.equals("postCount")) { prop = new Integer(this.getPostCount());}
		else if (propertyName.equals("topics")) { prop = this.getTopics();}
		else if (propertyName.equals("parentFolder")) { prop = this.getParentFolder();}
		else if (propertyName.equals("name")) { prop = this.getName();}
		else if (propertyName.equals("createdBy")) { prop = this.getCreatedBy();}
		else if (propertyName.equals("createdAt")) { prop = this.getCreatedAt();}
		else if (propertyName.equals("lastChangedBy")) { prop = this.getLastChangedBy();}
		else if (propertyName.equals("lastChangedAt")) { prop = this.getLastChangedAt();}
		
		//BOPublicLogger.exiting(null, jARMRequest, method, APPLICATION);
		
		return prop;
	}

	public void setProperty(String propertyName, Object propertyValue) {
		String method = "setProperty()";
		//BOPublicLogger.entering(null, jARMRequest, method, APPLICATION);

		if (propertyName.equals("createdBy")) { this.setCreatedBy((String)propertyValue);}
		else if (propertyName.equals("createdAt")) { this.setCreatedAt((Date)propertyValue);}
		else if (propertyName.equals("lastChangedBy")) { this.setLastChangedBy((String)propertyValue);}
		else if (propertyName.equals("lastChangedAt")) { this.setLastChangedAt((Date)propertyValue);}
		else if (propertyName.equals("key")) { this.setKey((String)propertyValue);}
		else if (propertyName.equals("documentId")) { this.setDocumentId((String)propertyValue);}
		else if (propertyName.equals("name")) { this.setName((java.lang.String)propertyValue);}
		else if (propertyName.equals("parentFolder")) { this.setParentFolder((java.lang.String)propertyValue);}
		else if (propertyName.equals("postCount")) { this.setPostCount(((java.lang.Integer)propertyValue).intValue());}
		
		else if (propertyName.equals("topics")) { setTopics((Collection)propertyValue);}		
	}

}
