package com.sap.caf.core.besrv.currency;

import java.util.*;
import java.io.Serializable;

import javax.jdo.InstanceCallbacks;
import javax.jdo.spi.PersistenceCapable;

import com.sap.caf.rt.bol.IBusinessObject;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.bol.pk.AbstractPrimaryKey;
import com.sap.caf.rt.bol.pk.PrimaryKeyFactory;
import com.sap.caf.rt.bol.da.DataAccessFactory;
import com.sap.caf.rt.bol.da.IDataAccessService;
import com.sap.caf.rt.exception.CAFBaseException;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.exception.MissingMandatoryValueException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.caf.rt.services.notify.notif.bobject.IBOChangedEvent;
import com.sap.caf.rt.services.notify.notif.bobject.BOUtils;
import com.sap.caf.rt.services.notify.subscr.bobject.BOSubscrType;

import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;


public class Currency implements IBusinessObject, Serializable, InstanceCallbacks { //$JL-SER$

	public Currency() {
	}

	private transient IBOChangedEvent notifEvent;
	private transient boolean notifEnabled = false;	
	private static final Location LOCATION = Location.getLocation(Currency.class);

  // keys
	private java.lang.String key;
  // attributes (without language dependent and relations)
	private java.util.Date lastChangedAt;
	private java.lang.String currencyCode;
	private java.lang.String lastChangedBy;
	private java.util.Date createdAt;
	private java.lang.String createdBy;
	private long numberFractionDigits;
	private java.lang.String currencyCodeISO;
  // relations

	private static final transient List propList = new ArrayList();
	private static final java.lang.String objectGuid = "E461F32E-CDFF-D02A-C6A5-EA20708B";

	public static final java.lang.String PROVIDER = "sap.com";
	public static final java.lang.String APPLICATION = "caf.core";
	public static final java.lang.String BE_SRV_NAME = "Currency";
	public static final java.lang.String OBJECT_NAME = PROVIDER + "/" + APPLICATION + "/" + BE_SRV_NAME;
	public static final java.lang.String JARM_REQUEST = "XAP:BO:" + OBJECT_NAME;

	static {
		propList.add("key");
		propList.add("lastChangedAt");
		propList.add("currencyCode");
		propList.add("lastChangedBy");
		propList.add("createdAt");
		propList.add("createdBy");
		propList.add("numberFractionDigits");
		propList.add("currencyCodeISO");
	}

	public List getPropertyList() {
		java.lang.String method = Currency.JARM_REQUEST + ":getPropertyList()";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return propList;
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public boolean validate() {
		java.lang.String method = Currency.JARM_REQUEST + ":validate()";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return true;
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.lang.String getRid() {
		java.lang.String method = Currency.JARM_REQUEST + ":getRid()";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return CAFContext.KM_REPOSITORY + "/" + objectGuid + "/" + getKey().substring(0, 2) + "/" + getKey().substring(0, 4) + "/r" + getKey();
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.lang.String getObjectType() {
		java.lang.String method = Currency.JARM_REQUEST + ":getObjectType()";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return OBJECT_NAME;
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

// *** GET/SET relations ***
// *** GET/SET keys ***
	public AbstractPrimaryKey getPK() {
		java.lang.String method = Currency.JARM_REQUEST + ":getPK()";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return new CurrencyPK(getKey());
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.lang.String getKey () {
		java.lang.String method = Currency.JARM_REQUEST + ":getKey ()";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.key;
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	protected void setKey (java.lang.String key) {
		java.lang.String method = Currency.JARM_REQUEST + ":setKey (java.lang.String)";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, new Object[] {key}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("key", this.key);
			}
			this.key = key;
			if (notifEnabled) {
				notifEvent.registerNewValue("key", this.key);
			}
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

// *** GET/SET attributes ***
	public java.util.Date getLastChangedAt () {
		java.lang.String method = Currency.JARM_REQUEST + ":getLastChangedAt ()";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.lastChangedAt;
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	protected void setLastChangedAt (java.util.Date lastChangedAt) {
		java.lang.String method = Currency.JARM_REQUEST + ":setLastChangedAt (java.util.Date)";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, new Object[] {this.lastChangedAt}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("lastChangedAt", this.lastChangedAt);
			}
			this.lastChangedAt = lastChangedAt;
			if (notifEnabled) {
				notifEvent.registerNewValue("lastChangedAt", this.lastChangedAt);
			}
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.lang.String getCurrencyCode () {
		java.lang.String method = Currency.JARM_REQUEST + ":getCurrencyCode ()";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.currencyCode;
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void setCurrencyCode (java.lang.String currencyCode) {
		java.lang.String method = Currency.JARM_REQUEST + ":setCurrencyCode (java.lang.String)";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, new Object[] {this.currencyCode}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("currencyCode", this.currencyCode);
			}
			if (currencyCode != null) {
				this.currencyCode = currencyCode.trim();
				if (this.currencyCode.length() == 0) {
					this.currencyCode = null;
				}
			} else {
				this.currencyCode = null;
			}
			if (notifEnabled) {
				notifEvent.registerNewValue("currencyCode", this.currencyCode);
			}
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.lang.String getLastChangedBy () {
		java.lang.String method = Currency.JARM_REQUEST + ":getLastChangedBy ()";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.lastChangedBy;
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	protected void setLastChangedBy (java.lang.String lastChangedBy) {
		java.lang.String method = Currency.JARM_REQUEST + ":setLastChangedBy (java.lang.String)";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, new Object[] {this.lastChangedBy}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("lastChangedBy", this.lastChangedBy);
			}
			if (lastChangedBy != null) {
				this.lastChangedBy = lastChangedBy.trim();
				if (this.lastChangedBy.length() == 0) {
					this.lastChangedBy = null;
				}
			} else {
				this.lastChangedBy = null;
			}
			if (notifEnabled) {
				notifEvent.registerNewValue("lastChangedBy", this.lastChangedBy);
			}
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.util.Date getCreatedAt () {
		java.lang.String method = Currency.JARM_REQUEST + ":getCreatedAt ()";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.createdAt;
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	protected void setCreatedAt (java.util.Date createdAt) {
		java.lang.String method = Currency.JARM_REQUEST + ":setCreatedAt (java.util.Date)";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, new Object[] {this.createdAt}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("createdAt", this.createdAt);
			}
			this.createdAt = createdAt;
			if (notifEnabled) {
				notifEvent.registerNewValue("createdAt", this.createdAt);
			}
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.lang.String getCreatedBy () {
		java.lang.String method = Currency.JARM_REQUEST + ":getCreatedBy ()";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.createdBy;
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	protected void setCreatedBy (java.lang.String createdBy) {
		java.lang.String method = Currency.JARM_REQUEST + ":setCreatedBy (java.lang.String)";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, new Object[] {this.createdBy}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("createdBy", this.createdBy);
			}
			if (createdBy != null) {
				this.createdBy = createdBy.trim();
				if (this.createdBy.length() == 0) {
					this.createdBy = null;
				}
			} else {
				this.createdBy = null;
			}
			if (notifEnabled) {
				notifEvent.registerNewValue("createdBy", this.createdBy);
			}
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public long getNumberFractionDigits () {
		java.lang.String method = Currency.JARM_REQUEST + ":getNumberFractionDigits ()";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.numberFractionDigits;
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void setNumberFractionDigits (long numberFractionDigits) {
		java.lang.String method = Currency.JARM_REQUEST + ":setNumberFractionDigits (long)";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, new Object[] {new java.lang.Long(this.numberFractionDigits)}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("numberFractionDigits", new java.lang.Long(this.numberFractionDigits));
			}
			this.numberFractionDigits = numberFractionDigits;
			if (notifEnabled) {
				notifEvent.registerNewValue("numberFractionDigits", new java.lang.Long(this.numberFractionDigits));
			}
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public java.lang.String getCurrencyCodeISO () {
		java.lang.String method = Currency.JARM_REQUEST + ":getCurrencyCodeISO ()";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return this.currencyCodeISO;
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void setCurrencyCodeISO (java.lang.String currencyCodeISO) {
		java.lang.String method = Currency.JARM_REQUEST + ":setCurrencyCodeISO (java.lang.String)";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, new Object[] {this.currencyCodeISO}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (notifEnabled) {
				notifEvent.registerOldValue("currencyCodeISO", this.currencyCodeISO);
			}
			if (currencyCodeISO != null) {
				this.currencyCodeISO = currencyCodeISO.trim();
				if (this.currencyCodeISO.length() == 0) {
					this.currencyCodeISO = null;
				}
			} else {
				this.currencyCodeISO = null;
			}
			if (notifEnabled) {
				notifEvent.registerNewValue("currencyCodeISO", this.currencyCodeISO);
			}
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

// *** Generic GET/SET methods ***
	public Object getProperty(java.lang.String propertyName) {
		java.lang.String method = Currency.JARM_REQUEST + ":getProperty(java.lang.String)";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, new Object[] {propertyName}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			Object prop = null;
			if (propertyName.equals("key")) {
				prop = this.getKey();
			} else if (propertyName.equals("lastChangedAt")) {
				prop = this.getLastChangedAt();
			} else if (propertyName.equals("currencyCode")) {
				prop = this.getCurrencyCode();
			} else if (propertyName.equals("lastChangedBy")) {
				prop = this.getLastChangedBy();
			} else if (propertyName.equals("createdAt")) {
				prop = this.getCreatedAt();
			} else if (propertyName.equals("createdBy")) {
				prop = this.getCreatedBy();
			} else if (propertyName.equals("numberFractionDigits")) {
				prop = new java.lang.Long(this.getNumberFractionDigits());
			} else if (propertyName.equals("currencyCodeISO")) {
				prop = this.getCurrencyCodeISO();
			}
			return prop;
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void setProperty(java.lang.String propertyName, Object propertyValue) {
		java.lang.String method = Currency.JARM_REQUEST + ":setProperty(java.lang.String, Object)";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, new Object[] {propertyName, propertyValue}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			if (propertyName.equals("key")) {
				this.setKey((java.lang.String) propertyValue);
			} else if (propertyName.equals("currencyCode")) {
				this.setCurrencyCode((java.lang.String) propertyValue);
			} else if (propertyName.equals("numberFractionDigits")) {
				this.setNumberFractionDigits(((java.lang.Long) propertyValue).longValue());
			} else if (propertyName.equals("currencyCodeISO")) {
				this.setCurrencyCodeISO((java.lang.String) propertyValue);
				}
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void jdoPostLoad() {
		java.lang.String method = Currency.JARM_REQUEST + ":jdoPostLoad()";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void jdoPreClear() {
	}

	public void jdoPreStore() {
	}

	public void jdoPreDelete() {
		java.lang.String method = Currency.JARM_REQUEST + ":jdoPreDelete()";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			IDataAccessService dataAccessService = null;
			HashSet relKeySet = null;
			java.lang.String relKey = null;
		
			try {
				dataAccessService = DataAccessFactory.getDataAccessService(DataAccessFactory.DATASOURCE_LOCAL);


				if (notifEnabled) {
					notifEvent.setType(BOSubscrType.DELETED);
				}
			} catch (Exception e) {
				CAFPublicLogger.traceThrowableT(Severity.DEBUG, Currency.LOCATION, method, "Error in " + method, e);
			}
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public IBOChangedEvent getNotifEvent() {
		java.lang.String method = Currency.JARM_REQUEST + ":getNotifEvent()";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			return notifEvent;
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public void setNotifEvent(IBOChangedEvent event) {
		java.lang.String method = Currency.JARM_REQUEST + ":setNotifEvent(IBOChangedEvent)";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, new Object[] {event}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			notifEvent = event;
			notifEnabled = event!=null && event.isEnabled();
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	void copyContentFrom(Currency source) throws CAFBaseException {
		java.lang.String method = Currency.JARM_REQUEST + ":copyContentFrom(Currency)";
		CAFPublicLogger.entering(null, Currency.JARM_REQUEST, method, Currency.LOCATION, new Object[] {source}, CAFPublicLogger.LEVEL_MEDIUM);
		try {
			this.setLastChangedAt(source.getLastChangedAt());
			this.setCurrencyCode(source.getCurrencyCode());
			this.setLastChangedBy(source.getLastChangedBy());
			this.setCreatedAt(source.getCreatedAt());
			this.setCreatedBy(source.getCreatedBy());
			this.setNumberFractionDigits(source.getNumberFractionDigits());
			this.setCurrencyCodeISO(source.getCurrencyCodeISO());
			this.setKey(source.getKey());
			this.setNotifEvent(source.getNotifEvent());
		} finally {
			CAFPublicLogger.exiting(null, Currency.JARM_REQUEST, method, Currency.LOCATION, CAFPublicLogger.LEVEL_MEDIUM);
		}
	}
	
	
	public boolean equals( Object o ) {
		if ( o == null ) {
			return false;
		}
		if ( ! this.getClass().equals( o.getClass() ) ) {
			return false;
		}
		
		Currency otherObj = ((Currency)o);
		boolean bEqual = this.getPK().equals( otherObj.getPK() );
		
		if ( bEqual ) {
			java.util.List attr = getPropertyList();
			java.util.Iterator it = attr.iterator();		
			
			while( it.hasNext() && bEqual ) {
				String attrName = (String)it.next();
				Object attr1 = getProperty( attrName );
				Object attr2 = otherObj.getProperty( attrName );
			
				if ( ( attr1 != null ) && ( attr2 != null ) ) {
					bEqual = attr1.equals( attr2 );
				}
				else {
					bEqual = ( attr1 == attr2 );
				}
			}
		}
		return bEqual;
	}	
	
	
	public int hashCode() {
		return this.getPK().hashCode();	
	}	
}